% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSF_dplyr.R
\name{DSF_dplyr}
\alias{DSF_dplyr}
\title{Apply a dplyr Transformation to a Data Stream}
\usage{
DSF_dplyr(dsd = NULL, func = NULL, info = FALSE)
}
\arguments{
\item{dsd}{A object of class \link{DSD}.}

\item{func}{a dplyr expression.}

\item{info}{logical; does the function also receive and modify the info columns?}
}
\value{
An object of class \code{DSF_dplyr} (subclass of \link{DSF} and \link{DSD}).
}
\description{
Applies dplyr transformations to a data stream.
}
\details{
\pkg{dplyr} needs to be installed and loaded with \code{library(dplyr)} before \code{DSF_dplyr} can be used.

Since streams are processed one point or block at a time, only \link[dplyr:dplyr-package]{dplyr::dplyr} operations that work on individual
rows are allowed on streams. Examples are:
\itemize{
\item \code{\link[dplyr:select]{dplyr::select()}}
\item \code{\link[dplyr:mutate]{dplyr::mutate()}}
\item \code{\link[dplyr:rename]{dplyr::rename()}}
\item \code{\link[dplyr:transmute]{dplyr::transmute()}}
\item \code{\link[dplyr:filter]{dplyr::filter()}}
}

Summary functions can be used, but will only be applied to the requested part of the stream of length \code{n}.

\code{DSF_dplyr()} calls the function using \verb{points \%>\% <func>} and multiple \code{dplyr} functions can be applied by
using \verb{\%>\%} between them.
}
\examples{
\dontshow{if (requireNamespace("dplyr", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

library(dplyr)

stream <- DSD_Gaussians(k = 3, d = 3)
plot(stream, xlim = c(0, 1), ylim = c(0, 1))

# 1. Select only columns X1 and X2
# 2. filter points by X1 > .5 (Note that the info columns also need to be filtered!)
# 3. Add a sum columns

stream2 <- stream \%>\%
  DSF_dplyr(select(X1, X2)) \%>\%
  DSF_dplyr(filter(X1 > .5), info = TRUE) \%>\%
  DSF_dplyr(mutate(Xsum = X1 + X2))
stream2

# Note: you get fewer points because of the filter operation.
get_points(stream2, n = 10)
plot(stream2, xlim = c(0, 1), ylim = c(0, 1))
\dontshow{\}) # examplesIf}
}
\seealso{
Other DSF: 
\code{\link{DSF}()},
\code{\link{DSF_Convolve}()},
\code{\link{DSF_Downsample}()},
\code{\link{DSF_ExponentialMA}()},
\code{\link{DSF_FeatureSelection}()},
\code{\link{DSF_Func}()},
\code{\link{DSF_Scale}()}
}
\author{
Michael Hahsler
}
\concept{DSF}
