% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSC_Reachability.R
\name{DSC_Reachability}
\alias{DSC_Reachability}
\title{Reachability Micro-Cluster Reclusterer}
\usage{
DSC_Reachability(
  formula = NULL,
  epsilon,
  min_weight = NULL,
  description = NULL
)
}
\arguments{
\item{formula}{\code{NULL} to use all features in the stream or a model \link{formula} of the form \code{~ X1 + X2}
to specify the features used for clustering. Only \code{.}, \code{+} and \code{-} are currently
supported in the formula.}

\item{epsilon}{radius of the epsilon-neighborhood.}

\item{min_weight}{micro-clusters with a weight less than this will be
ignored for reclustering.}

\item{description}{optional character string to describe the clustering
method.}
}
\value{
An object of class \code{DSC_Reachability}. The object contains the
following items:

\item{description}{The name of the algorithm in the DSC object.}
\item{RObj}{The underlying R object.}
}
\description{
Macro Clusterer.
Implementation of reachability clustering (based on DBSCAN's concept of
reachability) to recluster a set of micro-clusters.
}
\details{
Two micro-clusters are directly reachable if they are within each other's
epsilon-neighborhood (i.e., the distance between the centers is less then
epsilon). Two micro-clusters are reachable if they are connected by a chain
of pairwise directly reachable micro-clusters.  All mutually reachable
micro-clusters are put in the same cluster.

Reachability uses internally \link{DSC_Hierarchical} with single link.

\code{\link[=update]{update()}} and \code{\link[=recluster]{recluster()}} invisibly return the assignment of the data points
to clusters.

\strong{Note} that this clustering cannot be updated iteratively and every time it is
used for (re)clustering, the old clustering is deleted.
}
\examples{
#' # 3 clusters with 5\% noise
stream <- DSD_Gaussians(k = 3, d = 2, noise = 0.05)

# Use a moving window for "micro-clusters and recluster with DBSCAN (macro-clusters)
cl <- DSC_TwoStage(
  micro = DSC_Window(horizon = 100),
  macro = DSC_Reachability(eps = .05)
)

update(cl, stream, 500)
cl

plot(cl, stream)
}
\references{
Martin Ester, Hans-Peter Kriegel, Joerg Sander, Xiaowei Xu
(1996). A density-based algorithm for discovering clusters in large spatial
databases with noise. In Evangelos Simoudis, Jiawei Han, Usama M. Fayyad.
\emph{Proceedings of the Second International Conference on Knowledge
Discovery and Data Mining (KDD-96).} AAAI Press. pp. 226-231.
}
\seealso{
Other DSC_Macro: 
\code{\link{DSC_DBSCAN}()},
\code{\link{DSC_EA}()},
\code{\link{DSC_Hierarchical}()},
\code{\link{DSC_Kmeans}()},
\code{\link{DSC_Macro}()},
\code{\link{DSC_SlidingWindow}()}
}
\author{
Michael Hahsler
}
\concept{DSC_Macro}
