% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{sample_without_replacement}
\alias{sample_without_replacement}
\title{Sample Without Replacement}
\usage{
sample_without_replacement(
  population_vector,
  sampling_probabilities,
  sample_size
)
}
\arguments{
\item{population_vector}{Vector from which to draw samples.}

\item{sampling_probabilities}{Vector of probabilities of drawing each element of \code{population_vector}.}

\item{sample_size}{Number of samples to draw from \code{population_vector}. Must be less than or equal to \code{length(population_vector)}}
}
\value{
Vector of size \code{sample_size}
}
\description{
Draw \code{sample_size} samples from \code{population_vector} without replacement, weighted by \code{sampling_probabilities}

This function is intended for advanced use cases in which users require detailed control of sampling algorithms and data structures.
Minimal input validation and error checks are performed -- users are responsible for providing the correct inputs.
For tutorials on the "proper" usage of the stochtree's advanced workflow, we provide several vignettes at stochtree.ai
}
\examples{
a <- as.integer(c(4,3,2,5,1,9,7))
p <- c(0.7,0.2,0.05,0.02,0.01,0.01,0.01)
num_samples <- 5
sample_without_replacement(a, p, num_samples)
}
