% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ps_btscs.R
\name{ps_btscs}
\alias{ps_btscs}
\title{Create "peace years" or "spells" by cross-sectional unit, more generally}
\usage{
ps_btscs(data, event, tvar, csunit, pad_ts = FALSE)
}
\arguments{
\item{data}{the data set with which you are working}

\item{event}{some event (0, 1) for which you want spells or peace years}

\item{tvar}{the time variable (e.g. a year)}

\item{csunit}{the cross-sectional unit (likely a dyad if you're doing boilerplate international conflict stuff)}

\item{pad_ts}{should time-series be filled when panels are unbalanced/have gaps? Defaults to FALSE.}
}
\value{
\code{ps_btscs()} takes a data frame and returns the data frame with a new variable
named \code{spell}.
}
\description{
\code{ps_btscs()} allows you to create spells ("peace years" in
the international conflict context) between observations of some event. This
will allow the researcher to better model temporal dependence in binary time-series
cross-section ("BTSCS") models. It is an improvement on \code{sbtscs()} (included in
this package) by its ability to more flexibly work with data that have lots of \code{NAs}
that bracket the observed event data. It is used in the \code{peacesciencer} package.
}
\details{
This function is derived from \code{sbtscs()}. See documentation there for more information.
}
\examples{
\donttest{
library(dplyr)
library(stevemisc)
data(usa_mids)

# notice: no quotes
ps_btscs(usa_mids, midongoing, year, dyad)
}

}
\references{
Armstrong, Dave. 2016. ``\pkg{DAMisc}: Dave Armstrong's Miscellaneous Functions.''
\emph{R package version 1.4-3}.

Miller, Steven V. 2017. ``Quickly Create Peace Years for BTSCS Models with \code{sbtscs} in \code{stevemisc}.''
\url{https://svmiller.com/blog/2017/06/quickly-create-peace-years-for-btscs-models-with-stevemisc/}
}
\author{
David A. Armstrong, Steven V. Miller
}
