% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cls_unexported.R
\name{.to_num_from_complex}
\alias{.to_num_from_complex}
\title{Coerce an object from a complex to a numeric class}
\usage{
.to_num_from_complex(
  x,
  cast_fn,
  to_type_obj,
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)
}
\arguments{
\item{x}{The argument to stabilize.}

\item{cast_fn}{\verb{(function)} The \verb{as.*()} function to use for coercion.}

\item{to_type_obj}{An empty object of the target type (e.g., \code{integer()}).}

\item{x_arg}{\verb{(length-1 character)} An argument name for x. The automatic
value will work in most cases, or pass it through from higher-level
functions to make error messages clearer in unexported functions.}

\item{call}{\code{(environment)} The execution environment to mention as the
source of error messages.}

\item{x_class}{\verb{(length-1 character)} The class name of \code{x} to use in error
messages. Use this if you remove a special class from \code{x} before checking
its coercion, but want the error message to match the original class.}
}
\value{
\code{x} coerced to the target class.
}
\description{
A helper that wraps around a \verb{to_*()} function to provide a standard way to
coerce complex numbers.
}
\keyword{internal}
