% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_fct.R
\name{.coerce_fct_levels_impl}
\alias{.coerce_fct_levels_impl}
\title{Core implementation for applying factor levels}
\usage{
.coerce_fct_levels_impl(
  x,
  levels = NULL,
  to_na = character(),
  x_arg = caller_arg(x),
  call = caller_env()
)
}
\arguments{
\item{x}{The argument to stabilize.}

\item{levels}{\code{(character)} The desired factor levels.}

\item{to_na}{\code{(character)} Values to convert to \code{NA}.}

\item{x_arg}{\verb{(length-1 character)} An argument name for x. The automatic
value will work in most cases, or pass it through from higher-level
functions to make error messages clearer in unexported functions.}

\item{call}{\code{(environment)} The execution environment to mention as the
source of error messages.}
}
\value{
\code{x} as a factor with the specified levels.
}
\description{
Checks for values in \code{x} that are not present in \code{levels} and throws an error
if any are found.
}
\keyword{internal}
