% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_bulk_rankings.R
\name{ssar_bulk_rankings}
\alias{ssar_bulk_rankings}
\title{Get Bulk Rankings Report}
\usage{
ssar_bulk_rankings(
  date = Sys.Date() - 1,
  siteid = NULL,
  ranktype = "highest",
  engines = c("google", "bing"),
  currentlytracked = TRUE,
  crawledkeywords = TRUE,
  subdomain = Sys.getenv("SSAR_SUBDOMAIN"),
  apikey = Sys.getenv("SSAR_APIKEY")
)
}
\arguments{
\item{date}{The date being requested (required) in 'YYYY-MM-DD' format. Default is set to yesterday.}

\item{siteid}{The site id. If not provided then all sites will be returned. Comma separated list of specific site IDs, default is all sites.}

\item{ranktype}{This argument changes the call between getting the highest ranks for the keywords for the date with the value highest, or getting all the ranks for each engine for a keyword for a date with the value all. Defaults to highest if not provided.}

\item{engines}{This argument lets you choose which search engines to include in the export, defaulting to Google and Bing. Engines can be passed in comma separated to get multiple.}

\item{currentlytracked}{This argument will cause the API to ouptput only keywords which currently have tracking on at the time the API request is generated.}

\item{crawledkeywords}{This argument causes the API to only include output for keywords that were crawled on the date argument provided.}

\item{subdomain}{The account subdomain}

\item{apikey}{The api key from the account}
}
\value{
The dataframe with all keywords ranking information for the requested date
}
\description{
Retrieve a bulk report of all the rankings or for specific sites.
}
