% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmd_formatting.R
\name{format_rmd}
\alias{format_rmd}
\alias{rmd_a_bold}
\alias{rmd_a_italics}
\alias{rmd_a_bold_italics}
\alias{rmd_a_bold2}
\alias{rmd_a_italics2}
\alias{rmd_code_inline}
\alias{rmd_code_inline_r}
\alias{rmd_a_superscript}
\alias{rmd_a_subscript}
\alias{rmd_a_strikethrough}
\title{Add-ins for basic R Markdown formatting}
\usage{
rmd_a_bold()

rmd_a_italics()

rmd_a_bold_italics()

rmd_a_bold2()

rmd_a_italics2()

rmd_code_inline()

rmd_code_inline_r()

rmd_a_superscript()

rmd_a_subscript()

rmd_a_strikethrough()
}
\description{
RStudio add-ins, which enclose selected text with symbols that have special
interpretation in R Markdown. Function, symbols and interpretation \itemize{
  \item \code{rmd_bold()}:           between \code{**} and \code{**} as bold;
  \item \code{rmd_italics()}:        between \code{_} and \code{_} as italics;
  \item \code{rmd_bold_italics()}:   between \code{**_} and \code{_**}as bold italics;
  \item \code{rmd_bold2()}:          between \code{__} and \code{__} as bold;
  \item \code{rmd_italics2()}:       between \code{*} and \code{*} as italics;
  \item \code{rmd_code_inline()}:    between back-ticks (``) as inline code;
  \item \code{rmd_r_code_inline()}:  formats text as inline R code to evaluate;
  \item \code{rmd_superscript()}:    between \code{^} and \code{^} as superscript;
  \item \code{rmd_subscript()}:      between \code{~} and \code{~} as subscript;
  \item \code{rmd_strikethrough()}:  between \code{~~} and \code{~~} as strike-through text.
}
}
\seealso{
Other R Markdown formatting add-ins: \code{\link{rmd_equations}},
  \code{\link{rmd_list}}
}
