% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soiltexture.R
\name{TT.mahalanobis}
\alias{TT.mahalanobis}
\title{Calculates the Mahalanobis distance between clay silt and sand.}
\usage{
TT.mahalanobis(
  geo,
  tri.data,
  css.names = NULL,
  text.tol = NULL,
  text.sum = NULL,
  blr.clock = NULL,
  tri.sum.tst = NULL,
  tri.pos.tst = NULL,
  set.par = FALSE,
  n = 25,
  center = NULL,
  cov.mat = NULL,
  inverted = FALSE,
  ...,
  alr = FALSE,
  divisorvar = 2
)
}
\arguments{
\item{geo}{See \code{\link[soiltexture]{TT.plot}}}

\item{tri.data}{See \code{\link[soiltexture]{TT.plot}}}

\item{css.names}{See \code{\link[soiltexture]{TT.plot}}}

\item{text.tol}{See \code{\link[soiltexture]{TT.plot}}}

\item{text.sum}{See \code{\link[soiltexture]{TT.plot}}}

\item{blr.clock}{See \code{\link[soiltexture]{TT.plot}}}

\item{tri.sum.tst}{See \code{\link[soiltexture]{TT.plot}}}

\item{tri.pos.tst}{See \code{\link[soiltexture]{TT.plot}}}

\item{set.par}{If TRUE parameters are set automatically to their defualt value}

\item{n}{Number of points in the grid.}

\item{center}{Passed to \code{\link[stats]{mahalanobis}}}

\item{cov.mat}{Passed to \code{\link[stats]{mahalanobis}}}

\item{inverted}{Passed to \code{\link[stats]{mahalanobis}}}

\item{\dots}{More argument passed to \code{\link[stats]{mahalanobis}}}

\item{alr}{If TRUE an additive log-ratio transformation of the data is performed, and the Mahalanobis distance is computed on all classes but css.names[divisorvar]}

\item{divisorvar}{The Mahalanobis distance will be computed on all the texture class but css.names[divisorvar]}
}
\description{
Function that calculated the Mahalanobis distance between clay silt and
sand, on a regular x-y grid (back-transformed to Clay silt and sand for
Mahalanobis calculation). The underlying function is mahalanobis() by R
Development Core Team (2009)
}
\author{
Julien Moeys [aut, cre], Wei Shangguan [ctb], Rainer Petzold [ctb],
Budiman Minasny [ctb], Bogdan Rosca [ctb], Nic Jelinski [ctb], Wiktor
Zelazny [ctb], Rodolfo Marcondes Silva Souza [ctb], Jose Lucas Safanelli
[ctb], Alexandre ten Caten [ctb]
}
