% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TOwen1.R
\name{TOwen1}
\alias{TOwen1}
\title{Compute Owen's T Function \code{T(h, a)}}
\usage{
TOwen1(h, a, threads = 1)
}
\arguments{
\item{h}{numeric vector of \eqn{h} arguments.}

\item{a}{numeric vector of \eqn{a} arguments. Must be either the same length as \code{h}
or of length 1 (will be recycled by standard R rules).}

\item{threads}{integer. Number of threads to request from the C implementation (if supported).
Default is \code{1}.}
}
\value{
A numeric vector of length \code{length(h)} with the computed values. Elements
where either \code{h} or \code{a} is non-finite are \code{NA}. The returned
vector is given class \code{"snreg"} for downstream compatibility.
}
\description{
\code{TOwen1} computes an Owen's \eqn{T}-function variant (or a related
special function) for vectors \code{h} and \code{a} based on the \code{tha} function in \url{https://people.sc.fsu.edu/~jburkardt/c_src/owen/owen.html}. Non-finite inputs in \code{h} or \code{a}
yield \code{NA} at the corresponding positions.
}
\details{
Owen's T Function Variant via C Backend


Owen's \eqn{T} function is commonly defined as
\deqn{T(h, a) \;=\; \frac{1}{2\pi} \int_{0}^{a} \frac{\exp\!\left(-\tfrac{1}{2}h^2 (1+t^2)\right)}{1+t^2} \, dt,}
for real \eqn{h} and \eqn{a}.
}
\examples{
  library(snreg)
  
  # Basic usage. Vectorized 'a':
  h <- c(-1, 0, 1, 2)
  a <- 0.3
  TOwen1(h, a)

  # Vectorized 'a' with non-finite entries:
  a2 <- c(0.2, NA, 1, Inf)
  TOwen1(h, a2)

}
\seealso{
\code{\link{TOwen}}
}
