% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigma_attrs.R
\name{add_node_labels}
\alias{add_node_labels}
\title{Modify the node labels of a sgraph object.}
\usage{
add_node_labels(sigma_obj, label_attr = NULL)
}
\arguments{
\item{sigma_obj}{sgraph object, returned by sigma_from_igraph function}

\item{label_attr}{Attribute to use to replace node labels}
}
\value{
sgraph object with modified node labels
}
\description{
Modify the node labels of an existing sgraph object by providing an
attribute from the initial igraph to use as the labels.
}
\examples{
library(igraph)
library(sgraph)

data(lesMis)

sig <- sigma_from_igraph(igraph = lesMis) \%>\%
  add_node_labels(label_attr = 'label')
sig

}
