% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contributing_indices.R
\name{contributing_indices}
\alias{contributing_indices}
\title{Compute contributing units to table cells}
\usage{
contributing_indices(prob, ids = NULL)
}
\arguments{
\item{prob}{a \linkS4class{sdcProblem} object created with \code{\link[=makeProblem]{makeProblem()}}}

\item{ids}{a character vector containing default ids (strIDs) that define table
cells. Valid inputs can be extracted by using \code{\link[=sdcProb2df]{sdcProb2df()}} and looking at
column \code{strID}. If this argument is \code{NULL}, the corresponding units are computed
for all cells in the table.}
}
\value{
a named \verb{list where names correspond to the given }ids` and the values
to the row numbers within the raw input data.
}
\description{
This function computes (with respect to the raw input data) the indices of all
contributing units to given cells identified by \code{ids}.
}
\examples{
# loading test problem
p <- sdc_testproblem(with_supps = FALSE)
dt <- sdcProb2df(p, dimCodes = "original")

# question: which units contribute to cell region = "A" and gender = "female"?

# compute the id ("0102")
dt[region == "A" & gender == "female", strID]

# which indices contribute to the cell?
ids <- contributing_indices(prob = p, ids = "0101")

# check
dataObj <- get.sdcProblem(p, "dataObj")
rawData <- slot(dataObj, "rawData")
rawData[ids[["0101"]]]

# compute contributing ids for all cells
contributing_indices(p)
}
