% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/country_pattern.R
\name{country_pattern}
\alias{country_pattern}
\title{Country Instances}
\usage{
country_pattern(affiliations, pub_years = NULL, countries = NULL,
  only_first_author = F)
}
\arguments{
\item{affiliations}{A text vector containing affiliation (country) information}

\item{pub_years}{A numeric vector containing publication years}

\item{countries}{A list of countries (optional)}

\item{only_first_author}{Logical. If to find the author list by the first authors}
}
\value{
A list containing country output and other details.
}
\description{
Country-wise and year-wise output for a defined period.
}
\details{
The function returns year and country-wise output matrix if the publication years
are provided. If only affliation data is provided the country-wise output is returned as
a single vector instead of a matrix.
}
\examples{
affiliations<-c("Stanford University, Stanford, CA, United States; Montreal, QC, Canada",
"Stanford University, United States; Google Inc., United States",
"University of Michigan, Ann Arbor, MI 48109-2122, United States;
Tsinghua University, Beijing 100084, China",
"Imperial College London, London, SW7 2BZ, United Kingdom;
ENSTA, Ecole Polytechnique, Palaiseau, 91761, France")

pub_years<-c(2012,2012,2013,2014)

country_pattern( affiliations, pub_years)
country_pattern(affiliations)
}

