% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_trend_multi.R
\name{scMetaTraj_plot_trend_multi}
\alias{scMetaTraj_plot_trend_multi}
\title{Plot multiple module trends with switchpoints}
\usage{
scMetaTraj_plot_trend_multi(trend_long, switchpoints)
}
\arguments{
\item{trend_long}{Data frame with columns: module, mPT_bin, score_smooth.
Output from scMetaTraj_trend_multi()$trend_long.}

\item{switchpoints}{Data frame with columns: module, mPT_switch.
Output from scMetaTraj_trend_multi()$switchpoints.}
}
\value{
A ggplot2 object showing trends faceted by module.
}
\description{
Visualize metabolic module trends along pseudotime with identified
switchpoints marked by vertical dashed lines.
}
\examples{
# Create example trend data
trend_long <- data.frame(
  module = rep(c("Glycolysis", "OXPHOS"), each = 30),
  mPT_bin = rep(seq(0, 1, length.out = 30), 2),
  score_smooth = c(sin(seq(0, pi, length.out = 30)),
                   cos(seq(0, pi, length.out = 30)))
)

# Create example switchpoint data
switchpoints <- data.frame(
  module = c("Glycolysis", "OXPHOS"),
  mPT_switch = c(0.5, 0.3)
)

# Plot
p <- scMetaTraj_plot_trend_multi(trend_long, switchpoints)
print(p)

}
