% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md.R
\name{roxygen2md}
\alias{roxygen2md}
\title{Convert from Rd to Markdown in roxygen2 comments}
\usage{
roxygen2md(scope = c("full", "simple", "unlink", "indent", "none"))
}
\arguments{
\item{scope}{The scope of transformations: \code{"simple"} runs only transformations
that shouldn't substantially change the resulting \code{.Rd} files, \code{"full"} runs
all transformations. In larger packages, run \code{"none"}, double-check and track
the changes, and then run \code{"simple"} and then \code{"full"}.}
}
\value{
List of changed files, invisibly
}
\description{
Performs various substitutions in all \code{.R} files in a package
to make use of the Markdown functionality in \code{roxygen2}.
This function is designed for interactive use, see \code{\link[=markdownify]{markdownify()}} for details
on the transformations.
Also attempts to enable Markdown support in \code{roxygen2} by adding a field to
\code{DESCRIPTION}.
Carefully examine the results after running this function!
}
\examples{
if (interactive()) {
  # Convert roxygen to Markdown in one run
  roxygen2md()
}

# Alternatively, convert in three steps:
if (interactive()) {
  # 1. Enable Markdown processing
  roxygen2md("none")

  menu("Please examine/commit the changes and press 1 <enter> to continue.")

  # 2. Convert simple markup
  roxygen2md("simple")

  menu("Please examine/commit the changes and press 1 <enter> to continue.")

  # 3. (Optionally) Remove some of the \code{} expressions
  roxygen2md("unlink")

  menu(paste0(
    "Please remove all unwanted changes, commit the wanted ones, ",
    "and press 1 <enter> to continue."
  ))

  # 4. Convert everything, including links
  roxygen2md("full")
}
}
