% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rocsvm.solve.R
\name{rocsvm.solve}
\alias{rocsvm.solve}
\title{Finding Lagrangian multipliers of ROC-SVM by Qudratic Programming}
\usage{
rocsvm.solve(K, lambda, rho = 1, eps = 1e-08)
}
\arguments{
\item{K}{The kernelized matrix, i.e., K< .,. >.}

\item{lambda}{The regularization parameter that users want in ROC-SVM model.}

\item{rho}{A positive constant (default : 1)}

\item{eps}{Adjustment computing errors (default : 1e-08)}
}
\description{
Computes the Lagrangian multipliers(\code{alpha}), which are solutions of ROC-SVM using Quadratic Programming.
}
\examples{
\donttest{
n <- 30
p <- 2
delta <- 1
set.seed(309)
y <- c(rep(1, n/2), rep(-1, n/2))
x <- matrix(0, n, p)
for (i in 1:n){
 if (y[i] == 1) {
 x[i,] <- rnorm(p, -delta, 1)
 } else {
 x[i,] <- rnorm(p, delta, 1)
  }
 }

K <- radial.kernel(x,x)
rocsvm.solve(K, lambda = 1, rho = 1) }
}
\seealso{
\code{\link{rocsvm.path}}
}
\author{
Seung Jun Shin, Do Hyun Kim
}
