% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decompose_cnp.R
\name{decompose_cnp}
\alias{decompose_cnp}
\title{Split the CNP into its components}
\usage{
decompose_cnp(cnp)
}
\arguments{
\item{cnp}{a 13-digit number (or a vector of 13-digit numbers) representing
the Personal Numeric Code - CNP}
}
\value{
a named character vector splitting the CNP into its components.
}
\description{
A CNP is made up of 13 digits each with a specific meaning:
* \code{S} - the first digit is indicative of gender
* \code{AA} - digits 2-3 represent the last 2 digits of the year of birth
* \code{LL} - digits 4-5 represent the month of birth
* \code{ZZ} - digits 6-7 represent the day of birth
* \code{JJ} - digits 8-9 represent the county of birth (for native Romanians)
or the county of issue (for residents)
* \code{NNN}- digits 10-12 number between 001 and 999 used to differentiate
between people born on the same day in the same county
* \code{C} - digit 13 checksum
}
\examples{
decompose_cnp(6201206018078)
decompose_cnp(5201206346491)
}
