% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polycor.R
\name{polycor_mle}
\alias{polycor_mle}
\title{Maximum likelihood estimation of polychoric correlation coefficient}
\usage{
polycor_mle(
  x,
  y = NULL,
  variance = TRUE,
  constrained = "ifneeded",
  twostep = FALSE,
  method = NULL,
  maxcor = 0.999,
  tol_thresholds = 0.01,
  init = initialize_param(x, y)
)
}
\arguments{
\item{x}{Vector of integer-valued responses to first item, or contingency table (a \code{"\link[base]{table}"} object).}

\item{y}{Vector of integer-valued responses to second item; only required if \code{x} is not a contingency table.}

\item{variance}{Shall an estimated asymptotic covariance matrix be returned? Default is \code{TRUE}.}

\item{constrained}{Shall strict monotonicity of thresholds be explicitly enforced by linear constraints? This can be a logical (\code{TRUE} or \code{FALSE}), or \code{"ifneeded"} to first try unconstrained optimization and in case of an error perform constrained optimization. Default is \code{"ifneeded"}.}

\item{twostep}{Shall two-step estimation of Olsson (1979) <doi:10.1007/BF02296207> be performed? Default is \code{FALSE}.}

\item{method}{Numerical optimization method, see \code{\link[stats]{optim}()} and \code{\link[stats]{constrOptim}()}. Default is to use \code{"L-BFGS-B"} in case of unconstrained optimization and \code{"Nelder-Mead"} in case of constrained optimization.}

\item{maxcor}{Maximum absolute correlation (to ensure numerical stability). Default is 0.999.}

\item{tol_thresholds}{Minimum distance between consecutive thresholds (to enforce strict monotonicity); only relevant in case of constrained optimization. Default is 0.01.}

\item{init}{Initialization of numerical optimization. Default is neutral.}
}
\value{
An object of class \code{"robpolycor"}. See \code{\link{polycor}()} for details.
}
\description{
Implements the maximum likelihood estimator of Olsson (1979, Psychometrika, \doi{10.1007/BF02296207}) for the polychoric correlation model.
}
\examples{
## example data
set.seed(123)
x <- sample(c(1,2,3), size = 100, replace = TRUE)
y <- sample(c(1,2,3), size = 100, replace = TRUE)

polycor(x,y)     # robust
polycor_mle(x,y) # non-robust MLE

}
