/*
 * Decompiled with CFR 0.152.
 */
package internal.io;

import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.FileFormatter;
import nbbrd.io.Resource;
import nbbrd.io.function.IOFunction;
import nbbrd.io.function.IOSupplier;

public final class EncodingFileFormatter<T>
implements FileFormatter<T> {
    @NonNull
    final FileFormatter<T> formatter;
    @NonNull
    final IOFunction<OutputStream, ? extends FilterOutputStream> encoder;

    @Override
    public void formatFile(@NonNull T value, @NonNull File target) throws IOException {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        FileFormatter.super.formatFile(value, target);
    }

    @Override
    public void formatPath(@NonNull T value, @NonNull Path target) throws IOException {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        FileFormatter.super.formatPath(value, target);
    }

    @Override
    public void formatStream(@NonNull T value, @NonNull IOSupplier<? extends OutputStream> target) throws IOException {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        FileFormatter.super.formatStream(value, target);
    }

    @Override
    public void formatStream(@NonNull T value, @NonNull OutputStream resource) throws IOException {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
        try (OutputStream encoding = this.encoder.applyWithIO(Resource.uncloseableOutputStream(resource));){
            this.formatter.formatStream(value, encoding);
        }
    }

    @Generated
    public EncodingFileFormatter(@NonNull FileFormatter<T> formatter, @NonNull IOFunction<OutputStream, ? extends FilterOutputStream> encoder) {
        if (formatter == null) {
            throw new NullPointerException("formatter is marked non-null but is null");
        }
        if (encoder == null) {
            throw new NullPointerException("encoder is marked non-null but is null");
        }
        this.formatter = formatter;
        this.encoder = encoder;
    }
}

