/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.com.github.miachm.sods;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import standalone_spreadsheet.com.github.miachm.sods.NotAnOdsException;
import standalone_spreadsheet.com.github.miachm.sods.OdsOptionParameters;
import standalone_spreadsheet.com.github.miachm.sods.SpreadSheet;
import standalone_spreadsheet.com.github.miachm.sods.SpreadsheetParser;
import standalone_spreadsheet.com.github.miachm.sods.StylesParser;
import standalone_spreadsheet.com.github.miachm.sods.Uncompressor;
import standalone_spreadsheet.com.github.miachm.sods.XmlReader;
import standalone_spreadsheet.com.github.miachm.sods.XmlReaderEventImpl;
import standalone_spreadsheet.com.github.miachm.sods.XmlReaderInstance;
import standalone_spreadsheet.com.github.miachm.sods.XmlReaderInstanceEventImpl;

class OdsReader {
    private static final String CORRECT_MIMETYPE = "application/vnd.oasis.opendocument.spreadsheet";
    private static final Locale defaultLocal = Locale.US;
    private final Uncompressor uncompressor;
    private final XmlReader reader = new XmlReaderEventImpl();
    private final SpreadSheet spread;
    private final StylesParser stylesParser = new StylesParser();
    private final SpreadsheetParser spreadsheetParser;
    private final OdsOptionParameters options;

    private OdsReader(InputStream in, SpreadSheet spread, OdsOptionParameters options) {
        this.spread = spread;
        this.uncompressor = new Uncompressor(in);
        this.options = options;
        this.spreadsheetParser = new SpreadsheetParser(this.stylesParser, spread, options);
    }

    static void load(InputStream in, SpreadSheet spread) throws IOException {
        OdsReader reader = new OdsReader(in, spread, new OdsOptionParameters());
        reader.load();
    }

    static void load(InputStream in, SpreadSheet spread, OdsOptionParameters options) throws IOException {
        OdsReader reader = new OdsReader(in, spread, options);
        reader.load();
    }

    private void load() throws IOException {
        boolean mimetypeChecked = false;
        String entry = this.uncompressor.nextFile();
        while (entry != null) {
            if (entry.endsWith(".xml")) {
                this.processContent();
            } else if (entry.equals("mimetype")) {
                this.checkMimeType();
                mimetypeChecked = true;
            }
            entry = this.uncompressor.nextFile();
        }
        this.uncompressor.close();
        this.spread.trimSheets();
        if (!mimetypeChecked) {
            throw new NotAnOdsException("This file doesn't contain a mimetype");
        }
    }

    private void checkMimeType() throws IOException {
        byte[] buff = new byte[CORRECT_MIMETYPE.getBytes().length];
        this.uncompressor.getInputStream().read(buff);
        String mimetype = new String(buff);
        if (!mimetype.equals(CORRECT_MIMETYPE)) {
            throw new NotAnOdsException("This file doesn't look like an ODS file. Mimetype: " + mimetype);
        }
    }

    private void processContent() throws IOException {
        InputStream in = this.uncompressor.getInputStream();
        XmlReaderInstanceEventImpl instance = this.reader.load(in);
        if (instance == null) {
            return;
        }
        if (this.options.isLoadStyles()) {
            XmlReaderInstance stylesInstance = instance.nextElement("office:automatic-styles", "office:styles");
            this.stylesParser.parseStyles(stylesInstance);
        }
        XmlReaderInstance contentInstance = instance.nextElement("office:body");
        this.spreadsheetParser.parseContent(contentInstance);
        this.reader.close();
    }
}

