% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_cls.R
\name{read_factor}
\alias{read_factor}
\alias{read_cls}
\title{Read in a factor writtin in the CLS format}
\usage{
read_factor(con = stdin(), offset = 0)

read_cls(con = stdin(), offset = 0)
}
\arguments{
\item{con}{File or connection to read file from}

\item{offset}{The integer representing the first level, default is set to 0, for some software it can be set to 1}
}
\value{
A factor with levels as defined in the CLS file.
}
\description{
Read in a factor writtin in the CLS format
}
\note{
The original CLS format specifies that both tab or space can be used as separators.
This makes it unable to represent factors with sapces in levels. In order to accomodate
CLS format for these factors, we propose using tab as separators in CLS files when encoding factors
in R. The default setting of \code{read_factor} and \code{write_factor} uses tab. Though \code{read_factor}
can handle both separators, as long as in the file a separator is consistenly used.
}
\examples{
set.seed(1887)
tempfac <- factor(sample(LETTERS, 30, replace=TRUE), levels=sample(LETTERS))
tempfile <- tempfile()
write_factor(tempfac, tempfile)
stopifnot(identical(tempfac, read_factor(tempfile)))

write_factor(tempfac, tempfile, sep=" ")
stopifnot(identical(tempfac, read_factor(tempfile)))

idir <- system.file("extdata", package="ribiosIO")
sample.cls <- read_factor(file.path(idir, "test.cls"))
expFac <- factor(c("Case", "Control")[c(1,0,1,0,0,1,0,0,0,1,0,1,0,0,0,1,0,1,0,0,1,1,1,1,0,0)+1],
levels=c("Case", "Control"))
stopifnot(identical(sample.cls, expFac))

}
\seealso{
\code{\link{write_factor}}
}
