% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_gct.R
\name{longdf2gctMatrix}
\alias{longdf2gctMatrix}
\title{Convert a long data.frame into a GctMatrix}
\usage{
longdf2gctMatrix(
  longdf,
  row.col = 1L,
  desc.col = 2,
  column.col = 3,
  value.col = 4,
  missingValue = NULL
)
}
\arguments{
\item{longdf}{A data.frame object}

\item{row.col}{Integer or character string, index or name of the column in which row names are stored}

\item{desc.col}{Integer or character string,, index or name of the column in which feature descriptions are stored}

\item{column.col}{Integer or character string, index or name of the column in which sample names are stored}

\item{value.col}{Integer or character string, index or name of the column in which values are stored}

\item{missingValue}{Value used for missing values. If \code{NULL}, missing values are reported as NA and a warning will be raised if any value is missing. If \code{NA}, missing values are reported as NA and no warning is raised.}
}
\value{
A \code{GctMatrix} object
}
\description{
Convert a long data.frame into a GctMatrix
}
\examples{
idir <- system.file("extdata", package="ribiosIO")
sample.gct.file <- file.path(idir, "test.gct")
test.mat <- read_gct_matrix(sample.gct.file, keep.desc=TRUE)
test.long <- gctMatrix2longdf(test.mat)
test.rmat <- longdf2gctMatrix(test.long)
}
