% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseFuncs.R
\name{makeFactor}
\alias{makeFactor}
\title{Make a factor}
\usage{
makeFactor(groups, levels = NULL, make.names = TRUE, verbose = FALSE)
}
\arguments{
\item{groups}{Character strings}

\item{levels}{Character vector, indicating strings}

\item{make.names}{Should names be converted to adhere to the rule of variable names in R}

\item{verbose}{Logical vector}
}
\value{
A factor with the specified levels.
}
\description{
Make a factor
}
\examples{
makeFactor(c("A", "B", "C", "C", "A"), levels=LETTERS[3:1])
makeFactor(c("A 1", "B 2", "C 3", "C 3", "A 1"),
    levels=c("A 1", "C 3", "B 2"),
    make.names=TRUE)
makeFactor(c("A 1", "B 2", "C 3", "C 3", "A 1"),
    levels=c("A 1", "C 3", "B 2"),
    make.names=FALSE)
makeFactor(c("A 1", "B 2", "C 3", "C 3", "A 1"),
    levels=c("A 1", "C 3", "B 2"),
    make.names=FALSE, verbose=TRUE)
}
