% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ru_addpage.R
\name{ru_addpage}
\alias{ru_addpage}
\title{Add a Page Number Column to an Existing Dataframe}
\usage{
ru_addpage(
  dsetin,
  grpvars = NULL,
  stackvars = NULL,
  varlabls = NULL,
  rowsprbdy = NULL,
  startpaging = 0,
  lastbygrp = FALSE,
  fpage = "all",
  nftnotes = 0,
  nosplitvars = FALSE,
  npgvars = 0
)
}
\arguments{
\item{dsetin}{The dataframe for which a paging variable will be added.}

\item{grpvars}{Grouping variables used in the output (used for nosplitvars).}

\item{stackvars}{Specify stacked grouping variables (reduces # of page lines available for data).}

\item{varlabls}{Apply labels to outgoing dataframe.}

\item{rowsprbdy}{Number of rows in the body of the report.}

\item{startpaging}{Set to zero on first call, and > 0 on recalls to fix widows.}

\item{lastbygrp}{Set to true if this page is processing the last value of the grouping variables (used when footnote is applied only to last page).}

\item{fpage}{Setting to 'last' indicates that footnotes are only displayed on the last page.}

\item{nftnotes}{Enter the number of footnotes (determines # of page lines available for data).}

\item{nosplitvars}{Setting to true requires all values of the last grouping/stackvar must be on the same page (if possible).}

\item{npgvars}{Number of page-by variables for this report (reduces # of page lines available for data).}
}
\value{
A dataframe based on the incoming dataframe but with a paging variable added.
}
\description{
Take incoming dataframe and add page number variable to it accounting for grouping variables, stacked variables, and no-split variables.
}
\examples{
library(repfun)
library(dplyr)
datdir <- file.path(gsub("\\\\","/",tempdir(),fixed=TRUE),"datdir");
dir.create(datdir,showWarnings=FALSE)
repfun::copydata(datdir)
rfenv <- repfun::rs_setup(D_POPDATA=repfun::adsl \%>\% dplyr::filter(SAFFL =='Y'),
                 D_SUBJID=c("STUDYID","USUBJID"),
                 R_DICTION=NULL,
                 R_OTHERDATA=NULL,
                 R_INPUTDATA=NULL,
                 R_RAWDATA=NULL,
                 R_SDTMDATA=NULL,
                 R_ADAMDATA=datdir,
                 RetEnv=TRUE)
G_POPDATA <- rfenv$G_POPDATA \%>\%
 dplyr::mutate(TRT01AN=ifelse(TRT01A=='Placebo',1,
                ifelse(TRT01A=='Xanomeline Low Dose',2,3))) \%>\%
 repfun::ru_labels(varlabels=list('TRT01AN'='Actual Treatment for Period 001 (n)'))
adae <- rfenv$adamdata$adae.rda() \%>\%
        dplyr::inner_join(G_POPDATA, by=c('STUDYID','USUBJID','SAFFL','TRT01A'))
aesum_t <- repfun::ru_freq(
             adae,
             dsetindenom=G_POPDATA,
             countdistinctvars=c('STUDYID','USUBJID'),
             groupbyvarsnumer=c('TRT01AN','TRT01A','AEBODSYS','AEDECOD'),
             anyeventvars = c('AEBODSYS','AEDECOD'),
             anyeventvalues = c('ANY EVENT','ANY EVENT'),
             groupbyvarsdenom=c('TRT01AN'),
             resultstyle="NUMERPCT",
             totalforvar=c('TRT01AN'),
             totalid=99,
             totaldecode='Total',
             codedecodevarpairs=c("TRT01AN", "TRT01A"),
             varcodelistpairs=c(""),
             codelistnames=list(),
             resultpctdps=0) \%>\%
 repfun::ru_denorm(varstodenorm=c("tt_result", "PERCENT"),
           groupbyvars=c("tt_summarylevel", "AEBODSYS", "AEDECOD"),
           acrossvar="TRT01AN",
           acrossvarlabel="TRT01A",
           acrossvarprefix=c("tt_ac", "tt_p")) \%>\%
 dplyr::mutate(ord1=ifelse(tt_summarylevel==0,0,1)) \%>\%
 dplyr::rename(ord2=tt_summarylevel) \%>\%
 dplyr::arrange(ord1,AEBODSYS,ord2,AEDECOD) \%>\%
 dplyr::select(-c(starts_with('tt_p'),starts_with('ord')))

aesum_p3 <- repfun::ru_addpage(aesum_t,grpvars=c('AEBODSYS'),rowsprbdy=35,
                    nosplitvars=TRUE)
print(head(aesum_p3,10))

}
\author{
Chris Rook, \email{cr883296@gmail.com} \cr
Yongwei Wang, \email{yongwei.x.wang@viivhealthcare.com}
}
