% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refdb_filter.R
\name{refdb_filter_seq_stopcodon}
\alias{refdb_filter_seq_stopcodon}
\title{Filter sequences based on their number of of stop codons.}
\usage{
refdb_filter_seq_stopcodon(x, max_stop = 0, code, codon_frame = NA)
}
\arguments{
\item{x}{a reference database.}

\item{max_stop}{maximum number of stop codons.}

\item{code}{an integer indicating the genetic code to use for translation
(see \link[bioseq]{genetic-codes}).}

\item{codon_frame}{an integer giving the nucleotide position where
to start translation. If \code{NA} (the default), the three different frames
are tested and the frame producing the lowest number of stop codons will
be used.}
}
\value{
A tibble (filtered reference database).
}
\description{
Filter sequences based on their number of of stop codons.
}
\examples{
lib <- read.csv(system.file("extdata", "baetidae_bold.csv", package = "refdb"))
lib <- refdb_set_fields_BOLD(lib)
refdb_filter_seq_stopcodon(lib, code = 5)

}
