% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_plot.R
\name{simple_plot}
\alias{simple_plot}
\title{Function to generate conditional regression equation plots (i.e., simple effects) with \code{\link{rblimp}} and SIMPLE command}
\usage{
simple_plot(formula, model, ci = 0.95, xvals, ...)
}
\arguments{
\item{formula}{an object of class \code{\link{formula}} to specify simple effect to plot.
The formula must have the following form: \code{outcome ~ focal | moderator}. See Details below for nominal moderators.}

\item{model}{an \code{\link{blimp_obj}}. The model must have a SIMPLE command output saved.}

\item{ci}{a value between 0 and 1 specifying the credible interval size}

\item{xvals}{a list of values to evaluate for the focal variable. If empty, they will automatically be determined}

\item{...}{arguments passed to the internal \code{\link[ggplot2:geom_path]{ggplot2::geom_line}} call used to generate the median lines.}
}
\value{
a \code{\link[ggplot2:ggplot]{ggplot2::ggplot}} plot
}
\description{
Generates a conditional effect plots based on the posterior summaries from the output of \code{\link{rblimp}}.
}
\details{
To change colors use ggplot2's scale system. Both fill and color are used. See
\code{\link[ggplot2:aes_colour_fill_alpha]{ggplot2::aes_colour_fill_alpha}} for more information about setting a manual set of colors.

For nominal moderators, the variable must include the nominal code used in the dummy codes (e.g., moderator.1, moderator.2, etc).
When there are multiple dummy codes, then all codes must be listed using a \code{+}.
For example, after the \code{~} the following statement can be included:
\deqn{\code{focal | moderator.1 + moderator.2}}
}
\examples{
\dontshow{if (has_blimp()) withAutoprint(\{ # examplesIf}
# Generate Data
mydata <- rblimp_sim(
    c(
        'x ~ normal(0, 1)',
        'm ~ normal(0, 1)',
        'y ~ normal(10 + 0.5*x + m + 0.2*x*m, 1)'
    ),
    n = 100,
    seed = 981273
)

# Run Rblimp
m1 <- rblimp(
    'y ~ x m x*m',
    mydata,
    center = ~ m,
    simple = 'x | m',
    seed = 10972,
    burn = 1000,
    iter = 1000
)

# Generate Plot
simple_plot(y ~ x | m, m1)
\dontshow{\}) # examplesIf}
}
