test_that("can evaluate model properties", {
  features <- DataFeatures$new(
    formula = Formula::Formula(weight ~ 1 + age |
      0 + offset(height) | 0 + sex | 0),
    data = na.omit(starr)[1:10, ],
    response = TRUE)
  expect_equal(
    length(features$offsets[[2]]), 10L)
  expect_equal(
    lapply(features$model_matrices, dim),
    list(c(10, 2), c(10, 0), c(10, 2), c(10, 0)))
  expect_equal(
    features$n_parameters,
    list(2, 0, 2, 0))
  expect_equal(
    lapply(features$parameter_names, is.character),
    list(TRUE, FALSE, TRUE, FALSE))
  expect_equal(
    features$parameter_groups,
    factor(c(1, 1, 3, 3), levels = 1:4))
  expect_equal(
    lapply(features$linear_predictors(par = 1:4), dim),
    list(c(10, 1), c(10, 1), c(10, 1), c(10, 1)))
})
