% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifting_scheme.R
\name{custom_wavelet}
\alias{custom_wavelet}
\title{Create a custom wavelet}
\usage{
custom_wavelet(name, steps, norm = c(1, 1))
}
\arguments{
\item{name}{Identifier name for the wavelet.}

\item{steps}{List of steps created via \code{lift_step}.}

\item{norm}{Normalization vector c(K, 1/K).}
}
\value{
An object of class \code{lifting_scheme}.
}
\description{
Wrapper to create a \code{lifting_scheme} object from manual steps.
}
\examples{
p1 = lift_step("predict", c(1), position = "center")
u1 = lift_step("update", c(0.5), position = "center")
w = custom_wavelet("HaarManual", list(p1, u1), c(1.41, 0.707))
}
