% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evidence_schema.R
\name{validate_evidence}
\alias{validate_evidence}
\title{Validate Evidence Table}
\usage{
validate_evidence(ev)
}
\arguments{
\item{ev}{A data.frame to validate.}
}
\value{
\code{TRUE} invisibly if valid; throws an error otherwise.
}
\description{
Checks that a data.frame conforms to the evidence schema. Verifies column
presence, types, and controlled vocabulary values.
}
\examples{
ctx <- suppressMessages(r4sub_run_context("STUDY1", "DEV"))
ev <- suppressMessages(as_evidence(
  data.frame(
    asset_type = "validation", asset_id = "ADSL",
    source_name = "pinnacle21", indicator_id = "SD0001",
    indicator_name = "SD0001", indicator_domain = "quality",
    severity = "high", result = "fail",
    stringsAsFactors = FALSE
  ),
  ctx = ctx
))
validate_evidence(ev)

}
