% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_ids.R
\name{hash_id}
\alias{hash_id}
\title{Generate a Stable Hash ID}
\usage{
hash_id(..., prefix = NULL)
}
\arguments{
\item{...}{Character values to hash together. Concatenated with \code{"|"}.}

\item{prefix}{Optional prefix prepended to the hash (e.g., \code{"RUN"}, \code{"IND"}).}
}
\value{
A character string of the form \code{prefix-hexhash} or just \code{hexhash}.
}
\description{
Creates a deterministic hash from one or more character inputs. Uses MD5
via base R's \link[=base]{digest-like approach} for a lightweight, dependency-free
implementation.
}
\examples{
hash_id("ADSL", "rule_001")
hash_id("my_study", "2024-01-01", prefix = "RUN")

}
