% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameters.R
\name{has_parameters}
\alias{has_parameters}
\title{Check if a Quarto document uses parameters}
\usage{
has_parameters(input)
}
\arguments{
\item{input}{Path to the Quarto document (.qmd or .ipynb file) to inspect.}
}
\value{
Logical. \code{TRUE} if the document uses parameters, \code{FALSE} otherwise.
}
\description{
Determines whether a Quarto document uses parameters by examining the document
structure and metadata. This function works with both knitr and Jupyter engines,
using different detection methods for each:
}
\details{
\itemize{
\item \strong{Knitr engine (.qmd files)}: Checks for a "params" field in the document's
YAML metadata using \code{quarto_inspect()}
\item \strong{Jupyter engine (.ipynb files)}: Looks for code cells tagged with "parameters"
following the papermill convention. For .ipynb files, the function parses the
notebook JSON directly due to limitations in \verb{quarto inspect}.
}

Parameters in Quarto enable creating dynamic, reusable documents. This function
helps identify parameterized documents programmatically, which is useful for:
\itemize{
\item Document processing workflows
\item Automated report generation
\item Parameter validation before rendering
\item Project analysis and organization
}

For more information about using parameters in Quarto, see
\url{https://quarto.org/docs/computations/parameters.html}
}
\examples{
\dontrun{
# Check if a document uses parameters
has_parameters("my-document.qmd")

# Check a parameterized report
has_parameters("parameterized-report.qmd")

# Check a Jupyter notebook
has_parameters("analysis.ipynb")

# Use in a workflow
if (has_parameters("report.qmd")) {
  message("This document accepts parameters")
}
}

}
