% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{data_codebook_sentiment}
\alias{data_codebook_sentiment}
\title{Sentiment analysis codebook for movie reviews}
\format{
A \code{qlm_codebook} object containing:
\describe{
\item{name}{Task name: "Movie Review Sentiment"}
\item{instructions}{Coding instructions for analyzing movie review sentiment}
\item{schema}{Response schema with two fields: \code{polarity} (Enum of "neg", "mixed", or "pos") and \code{rating} (Integer from 1 to 10)}
\item{role}{Expert film critic persona}
\item{input_type}{"text"}
}
}
\usage{
data_codebook_sentiment
}
\description{
A \code{qlm_codebook} object defining instructions for sentiment analysis of movie
reviews. Designed to work with \link{data_corpus_LMRDsample} but with an expanded
polarity scale that includes a "mixed" category.
}
\examples{
# View the codebook
data_codebook_sentiment

\donttest{
# Use with movie review corpus (requires API key)
coded <- qlm_code(data_corpus_LMRDsample[1:10],
                  data_codebook_sentiment,
                  model = "openai")

# Create multiple coded versions for comparison
coded1 <- qlm_code(data_corpus_LMRDsample[1:20],
                   data_codebook_sentiment,
                   model = "openai/gpt-4o-mini")
coded2 <- qlm_code(data_corpus_LMRDsample[1:20],
                   data_codebook_sentiment,
                   model = "openai/gpt-4o")

# Compare inter-rater reliability
comparison <- qlm_compare(coded1, coded2, by = "rating", level = "interval")
print(comparison)
}
}
\seealso{
\code{\link[=qlm_codebook]{qlm_codebook()}}, \code{\link[=qlm_code]{qlm_code()}}, \code{\link[=qlm_compare]{qlm_compare()}}, \link{data_corpus_LMRDsample}
}
\keyword{data}
