% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy.R
\name{copy}
\alias{copy}
\alias{copy,Quadtree-method}
\alias{copy.Quadtree}
\title{Create a deep copy of a \code{Quadtree}}
\usage{
\S4method{copy}{Quadtree}(x)
}
\arguments{
\item{x}{a \code{\link{Quadtree}}}
}
\value{
a \code{\link{Quadtree}}
}
\description{
Creates a \emph{deep} copy of a \code{\link{Quadtree}}.
}
\details{
This function creates a \emph{deep} copy of a \code{\link{Quadtree}}
  object. The \code{\link{Quadtree}} class contains a pointer to a
  \code{\link{CppQuadtree}} C++ object. If a copy is attempted by simply
  assigning the quadtree to a new variable, it will simply make a copy of the
  \emph{pointer}, and both variables will point to the same
  \code{\link{CppQuadtree}}. Thus, changes made to one will also change the
  other. See "Examples" for a demonstration of this.

  This function creates a deep copy by copying the entire quadtree, and
  should be used whenever a copy of a quadtree is desired.
}
\examples{
library(quadtree)
habitat <- terra::rast(system.file("extdata", "habitat.tif", package="quadtree"))

# create a quadtree, then create a shallow copy and a deep copy
qt1 <- quadtree(habitat, split_threshold = .1)
plot(qt1)

qt2 <- qt1 # SHALLOW copy
qt3 <- copy(qt1) # DEEP copy

# change the values of qt1 so we can observe how this affects qt2 and qt3
transform_values(qt1, function(x) 1 - x)

# plot it out to see what happened
old_par <- par(mfrow = c(1, 3))
plot(qt1, main = "qt1", border_col = "transparent")
plot(qt2, main = "qt2", border_col = "transparent")
plot(qt3, main = "qt3", border_col = "transparent")
par(old_par)
# qt2 was modified but qt3 was not
}
