% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_feature_tbl.R
\name{get.gene.locations}
\alias{get.gene.locations}
\title{Helper function to set gene locations on plot.}
\usage{
get.gene.locations(
  locs,
  xlim,
  text_size = 3,
  str_rect = c("iW", "i"),
  n_rows = 10,
  plot_width = 6,
  ...
)
}
\arguments{
\item{locs}{tbl of gene information}

\item{xlim}{X axis limits}

\item{text_size}{size of text (default 3)}

\item{str_rect}{character spacing on left and right of rectangles (default c("iW","i"))}

\item{n_rows}{desired number of rows (default 10)}

\item{plot_width}{width of default plot window (in inches)}

\item{...}{additional parameters (not used)}
}
\value{
list object used by \code{\link{ggplot_feature_tbl}}
}
\description{
Figure out gene locations to make room for gene names.
Written original by Dan Gatti 2013-02-13
}
\references{
\url{https://github.com/dmgatti/DOQTL/blob/master/R/gene.plot.R}
}
\author{
Brian S Yandell, \email{brian.yandell@wisc.edu}
   Daniel Gatti, \email{Dan.Gatti@jax.org}
}
\keyword{utilities}
