% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_topology_file_as_tibble.R
\name{load_topology_file_as_tibble}
\alias{load_topology_file_as_tibble}
\title{Parse a topology (\code{.topo}) file to a table
with a \code{name} and \code{topology} column}
\usage{
load_topology_file_as_tibble(topology_filename)
}
\arguments{
\item{topology_filename}{name of the file to save a protein's
topology to}
}
\value{
a \link[tibble]{tibble}
with a \code{name} and \code{topology} column,
as can be checked by \link{check_topology}
}
\description{
Parse a topology (\code{.topo}) file to a table
with a \code{name} and \code{topology} column
}
\examples{
topology_filename <- system.file(
 "extdata", "100507436.topo", package = "pureseqtmr"
)
load_topology_file_as_tibble(topology_filename)
}
