% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_pum.R
\name{predict_pum}
\alias{predict_pum}
\title{Calculate Probabilities for Probit Unfolding Models}
\usage{
predict_pum(vote_info, years_v = NULL, post_samples)
}
\arguments{
\item{vote_info}{A logical vote matrix (or a rollcall object) in which rows represent members and columns represent issues.
The entries should be FALSE ("No"), TRUE ("Yes"), or NA (missing data).}

\item{years_v}{A vector representing the time period for each vote in the model. This is defultly set as `NULL` for a static model.}

\item{post_samples}{A list of posterior samples of parameters obtained from MCMC.}
}
\value{
An array of probabilities with three dimensions. The first one represents to members, the second one refers to issues,
and the third one refers to MCMC iterations.
}
\description{
This function computes the probability matrix for both static and dynamic Probit Unfolding Models.
Specifically, it calculates the probabilities of voting "Yea" for each legislator (member),
issue, (and time period) based on the posterior samples of model parameters.
}
\examples{
\donttest{
# Long-running example
data(h116)
h116.c = preprocess_rollcall(h116)
hyperparams <- list(beta_mean = 0, beta_var = 1, alpha_mean = c(0, 0),
                    alpha_scale = 5, delta_mean = c(-2, 10), delta_scale = sqrt(10))
control <- list(num_iter = 2, burn_in = 0, keep_iter = 1, flip_rate = 0.1)
h116.c.pum <- sample_pum_static(h116.c, hyperparams,
                                  control, pos_leg = grep("SCALISE", rownames(h116.c$votes)),
                                  verbose = FALSE, pre_run = NULL, appended = FALSE)
h116.c.pum.predprob = predict_pum(h116.c, years_v = NULL, h116.c.pum)
}
}
