% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conformal_infer_split.R
\name{int_conformal_split}
\alias{int_conformal_split}
\alias{int_conformal_split.default}
\alias{int_conformal_split.workflow}
\title{Prediction intervals via split conformal inference}
\usage{
int_conformal_split(object, ...)

\method{int_conformal_split}{default}(object, ...)

\method{int_conformal_split}{workflow}(object, cal_data, ...)
}
\arguments{
\item{object}{A fitted \code{\link[workflows:workflow]{workflows::workflow()}} object.}

\item{...}{Not currently used.}

\item{cal_data}{A data frame with the \emph{original predictor and outcome data}
used to produce predictions (and residuals). If the workflow used a recipe,
this should be the data that were inputs to the recipe (and not the product
of a recipe).}
}
\value{
An object of class \code{"int_conformal_split"} containing the
information to create intervals (which includes \code{object}).
The \code{predict()} method is used to produce the intervals.
}
\description{
Nonparametric prediction intervals can be computed for fitted regression
workflow objects using the split conformal inference method described by
Lei \emph{et al} (2018).
}
\details{
This function implements what is usually called "split conformal inference"
(see Algorithm 1 in Lei \emph{et al} (2018)).

This function prepares the statistics for the interval computations. The
\code{\link[=predict]{predict()}} method computes the intervals for new data and the signficance
level is specified there.

\code{cal_data} should be large enough to get a good estimates of a extreme
quantile (e.g., the 95th for 95\% interval) and should not include rows that
were in the original training set.
}
\examples{
\dontshow{if (!probably:::is_cran_check() & rlang::is_installed(c("modeldata", "parsnip", "nnet"))) withAutoprint(\{ # examplesIf}
library(workflows)
library(dplyr)
library(parsnip)
library(rsample)
library(tune)
library(modeldata)

set.seed(2)
sim_train <- sim_regression(500)
sim_cal <- sim_regression(200)
sim_new <- sim_regression(5) |> select(-outcome)

# We'll use a neural network model
mlp_spec <-
  mlp(hidden_units = 5, penalty = 0.01) |>
  set_mode("regression")

mlp_wflow <-
  workflow() |>
  add_model(mlp_spec) |>
  add_formula(outcome ~ .)

mlp_fit <- fit(mlp_wflow, data = sim_train)

mlp_int <- int_conformal_split(mlp_fit, sim_cal)
mlp_int

predict(mlp_int, sim_new, level = 0.90)
\dontshow{\}) # examplesIf}
}
\references{
Lei, Jing, et al. "Distribution-free predictive inference for regression."
\emph{Journal of the American Statistical Association} 113.523 (2018): 1094-1111.
}
\seealso{
\code{\link[=predict.int_conformal_split]{predict.int_conformal_split()}}
}
