% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_pivot_table.R
\name{make_pivot_table}
\alias{make_pivot_table}
\title{Make pivot table}
\usage{
make_pivot_table(
  tbl,
  col1,
  col2 = NULL,
  show_totals = TRUE,
  show_percentages = c("none", "all", "row", "col"),
  show_chi_test = FALSE,
  theme = c("zebra_blue", "zebra_gold", "tron", "vader", "vanilla", "booktabs",
    "alafoli"),
  tbl_nm = NULL,
  arrange_desc = TRUE
)
}
\arguments{
\item{tbl}{a data frame to pivot}

\item{col1}{unquoted col 1}

\item{col2}{unquoted col 2}

\item{show_totals}{logical; show row and col totals}

\item{show_percentages}{string; denominator to use when calculating percentages}

\item{show_chi_test}{logical; show results of chi squared test in footnote}

\item{theme}{string to choose a predefined theme}

\item{tbl_nm}{string to name table. If not given, automatically defaults to table name.}

\item{arrange_desc}{param for single col pivot table. if True arranges table by decreasing n size}
}
\value{
a flextable
}
\description{
If col2 is not supplied, will make a frequency table for 1 column.
}
