% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep.R
\name{prep}
\alias{prep}
\title{Automatic pre-preprocessing}
\usage{
prep(tserie, homogenize.method = "log", detrend.method = "differencing",
  nd = NULL, deseason.method = "differencing", nsd = NULL,
  detrend.first = TRUE)
}
\arguments{
\item{tserie}{A ts object.}

\item{homogenize.method}{A string. Current methods available are "log" and "boxcox". Method "log" is set as default. If you don't want to perform this transformation, set method as "none".}

\item{detrend.method}{A string. Current methods available are "differencing" and "sfsm". Method "differencing" is set as default. If you don't want to perform this transformation, set method as "none".}

\item{nd}{A number. Number of differences you want to apply to the "differencing" detrending method. As default its value is NULL, which means nd will be calculated internally.}

\item{deseason.method}{A string. Current methods available are "differencing". Method "differencing" is set as default. If you don't want to perform this transformation, set method as "none".}

\item{nsd}{A number. Number of seasonal differences you want to apply to the "differencing" deseasoning method. As default its value is NULL, which means nsd will be calculated internally.}

\item{detrend.first}{A boolean. TRUE if detrending method is applied first, then deseasoning. FALSE if deseasoning method is applied first. Default is TRUE.}
}
\value{
A list is returned of class \code{prep} containing:
\item{tserie}{Processed ts object.}
\item{homogenize.method}{Method used for homogenizing.}
\item{detrend.method}{Method used for detrending.}
\item{nd}{Number of differences used on detrending through differencing.}
\item{firstvalues}{First \code{nd} values of the original series.}
\item{deseason.method}{Method used for deseasoning.}
\item{nsd}{Number of seasonal differences used on deseasoning through differencing.}
\item{firstseasons}{First \code{nsd} seasons of the original series.}
\item{detrend.first}{Processed ts object}
\item{means}{Vector of means used in "sfsm" detrending method.}
\item{lambda}{Coefficient used in "boxcox" transformation.}
\item{start}{Start of the original time serie.}
\item{length}{Length of the original time serie.}
}
\description{
This function performs pre-processing on a time series object(ts) to treat
heterocedasticity, trend and seasonality in order to make the serie stationary.
}
\details{
Returns an object \code{prep} which stores all data needed to undo the changes later on.

This function provides an automatic way of pre-processing based on unit root tests, but
this is not the perfect way to do it. You should always check manually if
the given time serie is actually stationary, and modify the parameters according
to your thoughts.
}
\examples{
prep(AirPassengers)
prep(AirPassengers,homogenize.method='boxcox',detrend.method='none')
}
\references{
\url{https://www.otexts.org/fpp/8/1}
}
\seealso{
{
\code{\link{prep.homogenize.log}},
\code{\link{prep.homogenize.boxcox}},
\code{\link{prep.detrend.differencing}},
\code{\link{prep.detrend.sfsm}},
\code{\link{prep.deseason.differencing}},
\code{\link{prep.check.acf}},
\code{\link{prep.check.adf}}
}
}
\author{
Alberto Vico Moreno
}
