% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPercPyramid.R
\name{plotPercPyramid}
\alias{plotPercPyramid}
\title{Population percentage pyramid graph}
\usage{
plotPercPyramid(
  df,
  age,
  sex,
  perpop,
  labx = perpop,
  laby = age,
  twocolors = c("#41ae76", "#ef6548"),
  rotation = 0,
  n.breaks = 20,
  value.labels = TRUE,
  position.value.labels = "in",
  size.value.labels = 3
)
}
\arguments{
\item{df}{Name of dataframe}

\item{age}{Age or age group. Write the parameter in quotation marks.}

\item{sex}{Sex or other categorical grouping variable. Write the parameter in quotation marks.}

\item{perpop}{Percentage of population (in numerical value). Write the parameter in quotation marks.}

\item{labx}{X-axis label}

\item{laby}{Y-axis label}

\item{twocolors}{Two colors for the pyramid}

\item{rotation}{X-axis label rotation}

\item{n.breaks}{Number of breaks}

\item{value.labels}{Show values in the bars. Use TRUE to include the labels in the bars. Use FALSE to not include them.}

\item{position.value.labels}{Position of the values on the bars. Use "in" to display the labels inside the bars. Use "out" to display them outside the bars.}

\item{size.value.labels}{Font size of the values in the bars}
}
\value{
A graph of the pyramid of population percentage
}
\description{
Create a population percentage pyramid graph
}
\examples{
df <- popPyramid::popPER
df <- dplyr::filter(df, Year==2021)
df <- percDF(df, "gAge", "Sex", "Population")
plotPercPyramid(df=df, age="gAge", sex="Sex", perpop="perc_Population", value.labels=FALSE)

}
