% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_rtf.R
\name{table_rtf}
\alias{table_rtf}
\title{Read NONMEM output into a list.}
\usage{
table_rtf(
  df,
  outFile = NULL,
  rtfFile = TRUE,
  boldHeader = TRUE,
  rowNames = FALSE,
  ...
)
}
\arguments{
\item{df}{A data frame.}

\item{outFile}{A filename for writing the table to. If \code{NULL}, writes to console.}

\item{rtfFile}{If \code{TRUE} (the default), then add RTF tabs to generate a fully formatted RTF file.}

\item{boldHeader}{If \code{TRUE}, make the header bold.}

\item{rowNames}{If \code{TRUE}, include row names in the table. Default is \code{FALSE}.}

\item{...}{Other formatting options for the table body.}
}
\value{
An RTF table based on the data frame provided.
}
\description{
\code{table_rtf} generates an RTF table from a data frame.
}
\examples{
\dontrun{
scm <- read_scm("E:/DrugX/ModelDevelopment/scm310")
myRTF <- table_rtf(scm$forwardSummary)
}

}
\references{
\url{https://www.r-bloggers.com/2008/10/another-solution-to-the-r-to-word-table-problem/}
}
\author{
John Johnson, \email{johndjohnson@gmail.com}
}
