% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsers.R
\name{parsers}
\alias{parsers}
\alias{parse_csv}
\alias{parse_octet}
\alias{parse_rds}
\alias{parse_feather}
\alias{parse_parquet}
\alias{parse_text}
\alias{parse_tsv}
\alias{parse_yaml}
\alias{parse_geojson}
\alias{parse_multipart}
\title{Parser functions provided by plumber2}
\usage{
parse_csv(...)

parse_octet()

parse_rds(...)

parse_feather(...)

parse_parquet(...)

parse_text(multiple = FALSE)

parse_tsv(...)

parse_yaml(...)

parse_geojson(...)

parse_multipart(parsers = get_parsers())
}
\arguments{
\item{...}{Further argument passed on to the internal parsing function. See
Details for information on which function handles the parsing internally in
each parser}

\item{multiple}{logical: should the conversion be to a single
    character string or multiple individual characters?}

\item{parsers}{A list of parsers to use for parsing the parts of the body}
}
\value{
A function accepting a raw vector along with a \code{directives} argument
that provides further directives from the \code{Content-Type} to be passed along
}
\description{
These functions cover a large area of potential request body formats. They
are all registered to their standard mime types but users may want to use
them to register them to alternative types if they know it makes sense.
}
\section{Provided parsers}{
\itemize{
\item \code{parse_csv()} uses \code{\link[readr:read_delim]{readr::read_csv()}} for parsing. It is registered as
\code{"csv"} for the mime types \code{application/csv}, \code{application/x-csv},
\code{text/csv}, and \code{text/x-csv}
\item \code{parse_multipart} uses \code{\link[webutils:parse_multipart]{webutils::parse_multipart()}} for the initial
parsing. It then goes through each part and tries to find a parser that
matches the content type (either given directly or guessed from the file
extension provided). If a parser is not found it leaves the value as a raw
vector. It is registered as "\code{multi}" for the mime type \verb{multipart/*}
\item \code{parse_octet()} passes the raw data through unchanged. It is registered as
\code{"octet"} for the mime type \code{application/octet-stream}
\item \code{parse_rds()} uses \code{\link[=unserialize]{unserialize()}} for parsing. It is registered as
\code{"rds"} for the mime type \code{application/rds}
\item \code{parse_feather()} uses \code{arrow::read_feather()} for parsing. It is
registered as \code{"feather"} for the mime types
\code{application/vnd.apache.arrow.file} and \code{application/feather}
\item \code{parse_parquet()} uses \code{arrow::read_parquet()} for parsing. It is
registered as \code{"parquet"} for the mime type \code{application/vnd.apache.parquet}
\item \code{parse_text()} uses \code{\link[=rawToChar]{rawToChar()}} for parsing. It is registered as
\code{"text"} for the mime types \code{text/plain} and \verb{text/*}
\item \code{parse_tsv()} uses \code{\link[readr:read_delim]{readr::read_tsv()}} for parsing. It is registered as
\code{"tsv"} for the mime types \code{application/tab-separated-values} and
\code{text/tab-separated-values}
\item \code{parse_yaml()} uses \code{\link[yaml:yaml.load]{yaml::yaml.load()}} for parsing. It is registered as
\code{"yaml"} for the mime types \code{text/vnd.yaml}, \code{application/yaml},
\code{application/x-yaml}, \code{text/yaml}, and \code{text/x-yaml}
\item \code{parse_geojson()} uses \code{geojsonsf::geojson_sf()} for parsing. It is
registered as \code{"geojson"} for the mime types \code{application/geo+json} and
\code{application/vdn.geo+json}
}
\subsection{Additional registered parsers}{
\itemize{
\item \code{\link[reqres:parsers]{reqres::parse_json()}} is registered as "\code{json}" for the mime types
\code{application/json} and \code{text/json}
\item \code{\link[reqres:parsers]{reqres::parse_queryform()}} is registered as "\code{form}" for the mime type
\code{application/x-www-form-urlencoded}
\item \code{\link[reqres:parsers]{reqres::parse_xml()}} is registered as "\code{xml}" for the mime types
\code{application/xml} and \code{text/xml}
\item \code{\link[reqres:parsers]{reqres::parse_html()}} is registered as "\code{html}" for the mime type
\code{text/html}
}
}
}

\examples{
# You can use parsers directly when adding handlers
pa <- api() |>
  api_post("/hello/<name:string>", function(name, body) {
    list(
      msg = paste0("Hello ", name, "!")
    )
  }, parsers = list("text/csv" = parse_csv()))

}
\seealso{
\code{\link[=register_parser]{register_parser()}}
}
