% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas.r
\name{BlockCanvas}
\alias{BlockCanvas}
\title{Block Canvas Class}
\description{
Block Canvas Class

Block Canvas Class
}
\details{
Canvas using Unicode block elements for 2x vertical resolution.
Uses half-block characters: upper half (U+2580), lower half (U+2584), full block (U+2588).

Resolution: 1x2 (1 horizontal, 2 vertical pixels per character)
}
\section{Super class}{
\code{\link[plotcli:Canvas]{plotcli::Canvas}} -> \code{BlockCanvas}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{upper_block}}{Upper half block character}

\item{\code{lower_block}}{Lower half block character}

\item{\code{full_block}}{Full block character}

\item{\code{pixel_state}}{Matrix tracking which half-pixels are set (0=none, 1=upper, 2=lower, 3=both)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BlockCanvas-new}{\code{BlockCanvas$new()}}
\item \href{#method-BlockCanvas-set_pixel}{\code{BlockCanvas$set_pixel()}}
\item \href{#method-BlockCanvas-clear}{\code{BlockCanvas$clear()}}
\item \href{#method-BlockCanvas-clone}{\code{BlockCanvas$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="apply_colors"><a href='../../plotcli/html/Canvas.html#method-Canvas-apply_colors'><code>plotcli::Canvas$apply_colors()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="draw_circle"><a href='../../plotcli/html/Canvas.html#method-Canvas-draw_circle'><code>plotcli::Canvas$draw_circle()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="draw_hline"><a href='../../plotcli/html/Canvas.html#method-Canvas-draw_hline'><code>plotcli::Canvas$draw_hline()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="draw_line"><a href='../../plotcli/html/Canvas.html#method-Canvas-draw_line'><code>plotcli::Canvas$draw_line()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="draw_points"><a href='../../plotcli/html/Canvas.html#method-Canvas-draw_points'><code>plotcli::Canvas$draw_points()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="draw_polygon"><a href='../../plotcli/html/Canvas.html#method-Canvas-draw_polygon'><code>plotcli::Canvas$draw_polygon()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="draw_polyline"><a href='../../plotcli/html/Canvas.html#method-Canvas-draw_polyline'><code>plotcli::Canvas$draw_polyline()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="draw_rect"><a href='../../plotcli/html/Canvas.html#method-Canvas-draw_rect'><code>plotcli::Canvas$draw_rect()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="draw_segment"><a href='../../plotcli/html/Canvas.html#method-Canvas-draw_segment'><code>plotcli::Canvas$draw_segment()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="draw_text"><a href='../../plotcli/html/Canvas.html#method-Canvas-draw_text'><code>plotcli::Canvas$draw_text()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="draw_vline"><a href='../../plotcli/html/Canvas.html#method-Canvas-draw_vline'><code>plotcli::Canvas$draw_vline()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="fill_area"><a href='../../plotcli/html/Canvas.html#method-Canvas-fill_area'><code>plotcli::Canvas$fill_area()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="fill_bar"><a href='../../plotcli/html/Canvas.html#method-Canvas-fill_bar'><code>plotcli::Canvas$fill_bar()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="fill_circle"><a href='../../plotcli/html/Canvas.html#method-Canvas-fill_circle'><code>plotcli::Canvas$fill_circle()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="fill_rect"><a href='../../plotcli/html/Canvas.html#method-Canvas-fill_rect'><code>plotcli::Canvas$fill_rect()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="print"><a href='../../plotcli/html/Canvas.html#method-Canvas-print'><code>plotcli::Canvas$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="render"><a href='../../plotcli/html/Canvas.html#method-Canvas-render'><code>plotcli::Canvas$render()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BlockCanvas-new"></a>}}
\if{latex}{\out{\hypertarget{method-BlockCanvas-new}{}}}
\subsection{Method \code{new()}}{
Initialize Block canvas
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BlockCanvas$new(width, height)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{width}}{Character width}

\item{\code{height}}{Character height}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BlockCanvas-set_pixel"></a>}}
\if{latex}{\out{\hypertarget{method-BlockCanvas-set_pixel}{}}}
\subsection{Method \code{set_pixel()}}{
Set a pixel in Block space
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BlockCanvas$set_pixel(x, y, color = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{X coordinate (1-based, in pixel space: 1 to width)}

\item{\code{y}}{Y coordinate (1-based, in pixel space: 1 to height*2, 1 = top)}

\item{\code{color}}{Optional color name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BlockCanvas-clear"></a>}}
\if{latex}{\out{\hypertarget{method-BlockCanvas-clear}{}}}
\subsection{Method \code{clear()}}{
Clear the canvas
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BlockCanvas$clear()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BlockCanvas-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BlockCanvas-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BlockCanvas$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
