% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize_city.R
\name{normalize_city}
\alias{normalize_city}
\title{Normalize City Names}
\usage{
normalize_city(x, country = "DE")
}
\arguments{
\item{x}{Character vector of city names.}

\item{country}{Character string of the ISO 2-character country code (e.g. "DE", "FR", "PL").}
}
\value{
Character vector of normalized names.
}
\description{
Normalizes city names for EEA countries using comprehensive rules tailored to each language/region.
}
\examples{
# Normalize German city names
# Normalize German city names
normalize_city(c("M\u00FCnchen", "K\u00F6ln", "Frankfurt a.M."), country = "DE")

# Normalize Swiss city names
normalize_city(c("Z\u00FCrich", "Gen\u00E8ve", "Basel-Stadt"), country = "CH")
}
