% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pguTransformator.R
\name{pgu.transformator}
\alias{pgu.transformator}
\title{pgu.transformator}
\format{
[R6::R6Class] object.
}
\description{
Transforms the data of pguIMP.
}
\details{
Performs a data transformation in order to achieve a normally distributed version of the dataframe.
This object is used by the shiny based gui and is not for use in individual R-scripts!
}
\author{
Sebastian Malkusch
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{trafoAlphabet}}{Returns the instance variable trafoAlphabte.}

\item{\code{trafoParameter}}{Returns the instance variable trafoParameter.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-pgu.transformator-new}{\code{pgu.transformator$new()}}
\item \href{#method-pgu.transformator-finalize}{\code{pgu.transformator$finalize()}}
\item \href{#method-pgu.transformator-print}{\code{pgu.transformator$print()}}
\item \href{#method-pgu.transformator-resetTrafoParameter}{\code{pgu.transformator$resetTrafoParameter()}}
\item \href{#method-pgu.transformator-trafoType}{\code{pgu.transformator$trafoType()}}
\item \href{#method-pgu.transformator-setTrafoType}{\code{pgu.transformator$setTrafoType()}}
\item \href{#method-pgu.transformator-addConstant}{\code{pgu.transformator$addConstant()}}
\item \href{#method-pgu.transformator-mirrorLogic}{\code{pgu.transformator$mirrorLogic()}}
\item \href{#method-pgu.transformator-setMirrorLogic}{\code{pgu.transformator$setMirrorLogic()}}
\item \href{#method-pgu.transformator-lambdaLOP}{\code{pgu.transformator$lambdaLOP()}}
\item \href{#method-pgu.transformator-setLambdaLOP}{\code{pgu.transformator$setLambdaLOP()}}
\item \href{#method-pgu.transformator-lambdaBC}{\code{pgu.transformator$lambdaBC()}}
\item \href{#method-pgu.transformator-lambdaAS}{\code{pgu.transformator$lambdaAS()}}
\item \href{#method-pgu.transformator-featureIdx}{\code{pgu.transformator$featureIdx()}}
\item \href{#method-pgu.transformator-addConstGenerator}{\code{pgu.transformator$addConstGenerator()}}
\item \href{#method-pgu.transformator-mirrorNumeric}{\code{pgu.transformator$mirrorNumeric()}}
\item \href{#method-pgu.transformator-mirrorData}{\code{pgu.transformator$mirrorData()}}
\item \href{#method-pgu.transformator-calculateAddConst}{\code{pgu.transformator$calculateAddConst()}}
\item \href{#method-pgu.transformator-translateNumeric}{\code{pgu.transformator$translateNumeric()}}
\item \href{#method-pgu.transformator-translateData}{\code{pgu.transformator$translateData()}}
\item \href{#method-pgu.transformator-backTranslateNumeric}{\code{pgu.transformator$backTranslateNumeric()}}
\item \href{#method-pgu.transformator-backTranslateData}{\code{pgu.transformator$backTranslateData()}}
\item \href{#method-pgu.transformator-lambdaEstimator}{\code{pgu.transformator$lambdaEstimator()}}
\item \href{#method-pgu.transformator-estimateLambda_temp}{\code{pgu.transformator$estimateLambda_temp()}}
\item \href{#method-pgu.transformator-estimateLambda}{\code{pgu.transformator$estimateLambda()}}
\item \href{#method-pgu.transformator-normalizeArcSine}{\code{pgu.transformator$normalizeArcSine()}}
\item \href{#method-pgu.transformator-optimizeTukeyLadderOfPowers}{\code{pgu.transformator$optimizeTukeyLadderOfPowers()}}
\item \href{#method-pgu.transformator-optimizeBoxCox}{\code{pgu.transformator$optimizeBoxCox()}}
\item \href{#method-pgu.transformator-transformNumeric}{\code{pgu.transformator$transformNumeric()}}
\item \href{#method-pgu.transformator-transformData}{\code{pgu.transformator$transformData()}}
\item \href{#method-pgu.transformator-transformLogModulus}{\code{pgu.transformator$transformLogModulus()}}
\item \href{#method-pgu.transformator-transformSquareRoot}{\code{pgu.transformator$transformSquareRoot()}}
\item \href{#method-pgu.transformator-transformCubeRoot}{\code{pgu.transformator$transformCubeRoot()}}
\item \href{#method-pgu.transformator-transformArcsine}{\code{pgu.transformator$transformArcsine()}}
\item \href{#method-pgu.transformator-transformInverse}{\code{pgu.transformator$transformInverse()}}
\item \href{#method-pgu.transformator-transformTukeyLadderOfPowers}{\code{pgu.transformator$transformTukeyLadderOfPowers()}}
\item \href{#method-pgu.transformator-transformBoxCox}{\code{pgu.transformator$transformBoxCox()}}
\item \href{#method-pgu.transformator-inverseTransformNumeric}{\code{pgu.transformator$inverseTransformNumeric()}}
\item \href{#method-pgu.transformator-inverseTransformData}{\code{pgu.transformator$inverseTransformData()}}
\item \href{#method-pgu.transformator-inverseTransformLogModulus}{\code{pgu.transformator$inverseTransformLogModulus()}}
\item \href{#method-pgu.transformator-inverseTransformSquareRoot}{\code{pgu.transformator$inverseTransformSquareRoot()}}
\item \href{#method-pgu.transformator-inverseTransformCubeRoot}{\code{pgu.transformator$inverseTransformCubeRoot()}}
\item \href{#method-pgu.transformator-inverseTransformArcsine}{\code{pgu.transformator$inverseTransformArcsine()}}
\item \href{#method-pgu.transformator-inverseTransformInverse}{\code{pgu.transformator$inverseTransformInverse()}}
\item \href{#method-pgu.transformator-inverseTransformTukeyLadderOfPowers}{\code{pgu.transformator$inverseTransformTukeyLadderOfPowers()}}
\item \href{#method-pgu.transformator-inverseTransformBoxCox}{\code{pgu.transformator$inverseTransformBoxCox()}}
\item \href{#method-pgu.transformator-fit}{\code{pgu.transformator$fit()}}
\item \href{#method-pgu.transformator-mutateData}{\code{pgu.transformator$mutateData()}}
\item \href{#method-pgu.transformator-reverseMutateData}{\code{pgu.transformator$reverseMutateData()}}
\item \href{#method-pgu.transformator-clone}{\code{pgu.transformator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-new"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-new}{}}}
\subsection{Method \code{new()}}{
Creates and returns a new `pgu.transformator` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$new(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `pgu.transformator` object.
(pguIMP::pgu.transformator)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-finalize}{}}}
\subsection{Method \code{finalize()}}{
Clears the heap and
indicates that instance of `pgu.transformator` is removed from heap.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$finalize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-print"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-print}{}}}
\subsection{Method \code{print()}}{
Prints instance variables of a `pgu.transformator` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-resetTrafoParameter"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-resetTrafoParameter}{}}}
\subsection{Method \code{resetTrafoParameter()}}{
Resets instance variable `trafoParameter`
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$resetTrafoParameter(data = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{Dataframe to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-trafoType"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-trafoType}{}}}
\subsection{Method \code{trafoType()}}{
Returns entry of `trafoType`
for user defined attribute.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$trafoType(feature = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature}}{Attribute's name.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Value of entry.
(character)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-setTrafoType"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-setTrafoType}{}}}
\subsection{Method \code{setTrafoType()}}{
Sets entry of `trafoType`
for user defined attribute.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$setTrafoType(feature = "character", type = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature}}{Attribute's name.
(character)}

\item{\code{type}}{Trafo type parameter. Valid choices are:
"none", "exponential", "log2", "logNorm", "log10", "arcsine", "tukeyLOP", "boxCox".
(character)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-addConstant"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-addConstant}{}}}
\subsection{Method \code{addConstant()}}{
Returns entry of `addConst`
for user defined attribute.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$addConstant(feature = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature}}{Attribute's name.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Value of entry.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-mirrorLogic"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-mirrorLogic}{}}}
\subsection{Method \code{mirrorLogic()}}{
Returns entry of `mirrorLogic`
for user defined attribute.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$mirrorLogic(feature = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature}}{Attribute's name.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Value of entry.
(logical)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-setMirrorLogic"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-setMirrorLogic}{}}}
\subsection{Method \code{setMirrorLogic()}}{
Sets entry of `mirrorLogic`
for user defined attribute.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$setMirrorLogic(feature = "character", logic = "logical")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature}}{Attribute's name.
(character)}

\item{\code{logic}}{Specifies whether the data should be mirrored at the coordinate origin.
(logical)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-lambdaLOP"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-lambdaLOP}{}}}
\subsection{Method \code{lambdaLOP()}}{
Returns entry of `lambda_lop`
for user defined attribute.
Lambda is a specific optimization parameter
that is derived from the Tukey-LOP
transfromation procedure.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$lambdaLOP(feature = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature}}{Attribute's name.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Value of entry.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-setLambdaLOP"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-setLambdaLOP}{}}}
\subsection{Method \code{setLambdaLOP()}}{
Sets entry of `lambda_lop`
for user defined attribute.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$setLambdaLOP(feature = "character", lambda = "numeric")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature}}{Attribute's name.
(character)}

\item{\code{lambda}}{Sets the feature specific exponential value.
(numeric)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-lambdaBC"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-lambdaBC}{}}}
\subsection{Method \code{lambdaBC()}}{
Returns entry of `lambda_bc`
for user defined attribute.
Lambda is a specific optimization parameter
that is derived from the Box-Cox
transfromation procedure.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$lambdaBC(feature = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature}}{Attribute's name.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Value of entry.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-lambdaAS"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-lambdaAS}{}}}
\subsection{Method \code{lambdaAS()}}{
Returns entry of `lambda_as`
for user defined attribute.
Lambda is a specific optimization parameter
that is derived from the arcsine
transfromation procedure.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$lambdaAS(feature = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature}}{Attribute's name.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Value of entry.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-featureIdx"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-featureIdx}{}}}
\subsection{Method \code{featureIdx()}}{
Returns the index of a pgu.normDist object wihtin the instance variable `trafoParameter`.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$featureIdx(feature = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature}}{Attribute's name.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Index of attribute entry in dataframe
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-addConstGenerator"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-addConstGenerator}{}}}
\subsection{Method \code{addConstGenerator()}}{
Calculates and returns the addConst.
A constant that prevents the occurrence of negative values as well as zero,
if added to an attribute.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$addConstGenerator(value = "numeric")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{The smallest of the attribute's values.
(numeric)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The addConst for the attribute
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-mirrorNumeric"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-mirrorNumeric}{}}}
\subsection{Method \code{mirrorNumeric()}}{
Mirrors the assigned values at the coordinate origin.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$mirrorNumeric(value = "numeric")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Value or vector of values.
(numeric)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Value or vector of values.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-mirrorData"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-mirrorData}{}}}
\subsection{Method \code{mirrorData()}}{
Calls the class' mirrorNumeric function on all numeric attributes of a data frame.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$mirrorData(data = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A data frame.
(tibble:tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-calculateAddConst"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-calculateAddConst}{}}}
\subsection{Method \code{calculateAddConst()}}{
Calculates the addConst value for each attribute of the assigned data frame,
by calling the class' addConstGenerator function.
The results are stored in addConst attribute of the trafoParameter instance variable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$calculateAddConst(data = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A data frame.
(tibble:tibble)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-translateNumeric"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-translateNumeric}{}}}
\subsection{Method \code{translateNumeric()}}{
Translates the assigned values by a constant.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$translateNumeric(value = "numeric", const = "numeric")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A numeric or a vector of numerics to be translated.
(numeric)}

\item{\code{const}}{A constant value.
(numeric)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric or a vector of numerics.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-translateData"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-translateData}{}}}
\subsection{Method \code{translateData()}}{
Translates each attribute of the assigned data frame,
by calling the class' translateNumeric function.
The respective addConst values of the individual attributes of the data frame
serve as const variables.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$translateData(data = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A data frame.
(tibble:tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame.
(tibble:tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-backTranslateNumeric"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-backTranslateNumeric}{}}}
\subsection{Method \code{backTranslateNumeric()}}{
Back-translates the assigned values by a constant.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$backTranslateNumeric(value = "numeric", const = "numeric")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A numeric or a vector of numerics to be back-translated.
(numeric)}

\item{\code{const}}{A constant value.
(numeric)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric or a vector of numerics.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-backTranslateData"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-backTranslateData}{}}}
\subsection{Method \code{backTranslateData()}}{
Back-translates each attribute of the assigned data frame,
by calling the class' backTranslateNumeric function.
The respective addConst values of the individual attributes of the data frame
serve as const variables.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$backTranslateData(data = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A data frame.
(tibble:tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame.
(tibble:tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-lambdaEstimator"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-lambdaEstimator}{}}}
\subsection{Method \code{lambdaEstimator()}}{
Estimates the lambda factor for the given values,
that are assigned to a user defined attribute..
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$lambdaEstimator(value = "numeric", feature = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A numeric or a vector of numerics to be analyzed.
(numeric)}

\item{\code{feature}}{The attribute which the given values are assigned to.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The specific lambda factor.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-estimateLambda_temp"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-estimateLambda_temp}{}}}
\subsection{Method \code{estimateLambda_temp()}}{
Estimates the lambda factor for each attribute of the assigned data frame,
by calling the class' lambdaEstimator function.
The respective lambda values of the individual attributes of the data frame
are stored in the lambda attribute of the instance variable trafoParameter.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$estimateLambda_temp(data = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A data frame.
(tibble:tibble)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-estimateLambda"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-estimateLambda}{}}}
\subsection{Method \code{estimateLambda()}}{
Estimates the arcsine transformation lambda factor
for each attribute of the assigned data frame.
The respective lambda values of the individual attributes of the data frame
are stored in the lambda attribute of the instance variable trafoParameter.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$estimateLambda(data = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A data frame.
(tibble:tibble)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-normalizeArcSine"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-normalizeArcSine}{}}}
\subsection{Method \code{normalizeArcSine()}}{
Estimates the lambda factor for an arcsine transformation for the given values,
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$normalizeArcSine(value = "numeric")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A numeric or a vector of numerics to be analyzed.
(numeric)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The specific lambda factor.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-optimizeTukeyLadderOfPowers"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-optimizeTukeyLadderOfPowers}{}}}
\subsection{Method \code{optimizeTukeyLadderOfPowers()}}{
Estimates the lambda factor for a tukeyLOP transformation for the given values,
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$optimizeTukeyLadderOfPowers(value = "numeric")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A numeric or a vector of numerics to be analyzed.
(numeric)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The specific lambda factor.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-optimizeBoxCox"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-optimizeBoxCox}{}}}
\subsection{Method \code{optimizeBoxCox()}}{
Estimates the lambda factor for a boxcox transformation for the given values,
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$optimizeBoxCox(value = "numeric")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A numeric or a vector of numerics to be analyzed.
(numeric)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The specific lambda factor.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-transformNumeric"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-transformNumeric}{}}}
\subsection{Method \code{transformNumeric()}}{
Transforms the given numeric values,
that are assigned to a user defined attribute.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$transformNumeric(value = "numeric", feature = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A numeric or a vector of numerics to be tranformed.
(numeric)}

\item{\code{feature}}{The attribute which the given values are assigned to.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A transfromed version of the given numeric or vector of numerics.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-transformData"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-transformData}{}}}
\subsection{Method \code{transformData()}}{
Transforms each attribute of the assigned data frame,
by calling the class' tranformNumeric function.
The respective lambda values of the individual attributes of the data frame
are read from the lambda attribute of the instance variable trafoParameter.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$transformData(data = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A data frame.
(tibble:tibble)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-transformLogModulus"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-transformLogModulus}{}}}
\subsection{Method \code{transformLogModulus()}}{
Performes a log transformation for the given values,
based on a user defined base value.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$transformLogModulus(value = "numeric", base = "numeric")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A numeric or a vector of numerics to be analyzed.
(numeric)}

\item{\code{base}}{Logarithmic base.
(numeric)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The transformed values.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-transformSquareRoot"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-transformSquareRoot}{}}}
\subsection{Method \code{transformSquareRoot()}}{
Performes a square root transformation for the given values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$transformSquareRoot(value = "numeric")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A numeric or a vector of numerics to be analyzed.
(numeric)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The transformed values.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-transformCubeRoot"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-transformCubeRoot}{}}}
\subsection{Method \code{transformCubeRoot()}}{
Performes a cube root transformation for the given values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$transformCubeRoot(value = "numeric")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A numeric or a vector of numerics to be analyzed.
(numeric)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The transformed values.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-transformArcsine"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-transformArcsine}{}}}
\subsection{Method \code{transformArcsine()}}{
Performes an arcsine transformation for the given values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$transformArcsine(value = "numeric", lambda = "numeric")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A numeric or a vector of numerics to be analyzed.
(numeric)}

\item{\code{lambda}}{Normalization factor.
(numeric)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The transformed values.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-transformInverse"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-transformInverse}{}}}
\subsection{Method \code{transformInverse()}}{
Performes an inverse transformation for the given values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$transformInverse(value = "numeric")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A numeric or a vector of numerics to be analyzed.
(numeric)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The transformed values.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-transformTukeyLadderOfPowers"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-transformTukeyLadderOfPowers}{}}}
\subsection{Method \code{transformTukeyLadderOfPowers()}}{
Performes a tukeyLOP transformation for the given values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$transformTukeyLadderOfPowers(
  value = "numeric",
  lambda = "numeric"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A numeric or a vector of numerics to be analyzed.
(numeric)}

\item{\code{lambda}}{Lambda factor.
(numeric)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The transformed values.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-transformBoxCox"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-transformBoxCox}{}}}
\subsection{Method \code{transformBoxCox()}}{
Performes a boxcox transformation for the given values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$transformBoxCox(value = "numeric", lambda = "numeric")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A numeric or a vector of numerics to be analyzed.
(numeric)}

\item{\code{lambda}}{Lambda factor.
(numeric)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The transformed values.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-inverseTransformNumeric"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-inverseTransformNumeric}{}}}
\subsection{Method \code{inverseTransformNumeric()}}{
Inverse transforms the given numeric values,
that are assigned to a user defined attribute.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$inverseTransformNumeric(
  value = "numeric",
  feature = "character"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A numeric or a vector of numerics to be tranformed.
(numeric)}

\item{\code{feature}}{The attribute which the given values are assigned to.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An inverse transfromed version of the given numeric or vector of numerics.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-inverseTransformData"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-inverseTransformData}{}}}
\subsection{Method \code{inverseTransformData()}}{
Inverse transforms each attribute of the assigned data frame,
by calling the class' tranformNumeric function.
The respective lambda values of the individual attributes of the data frame
are read from the lambda attribute of the instance variable trafoParameter.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$inverseTransformData(data = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A data frame.
(tibble:tibble)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-inverseTransformLogModulus"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-inverseTransformLogModulus}{}}}
\subsection{Method \code{inverseTransformLogModulus()}}{
Performes an inverse log transformation for the given values,
based on a user defined base value.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$inverseTransformLogModulus(
  value = "numeric",
  base = "numeric"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A numeric or a vector of numerics to be analyzed.
(numeric)}

\item{\code{base}}{Logarithmic base.
(numeric)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The transformed values.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-inverseTransformSquareRoot"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-inverseTransformSquareRoot}{}}}
\subsection{Method \code{inverseTransformSquareRoot()}}{
Performes an inverse square root transformation for the given values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$inverseTransformSquareRoot(value = "numeric")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A numeric or a vector of numerics to be analyzed.
(numeric)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The transformed values.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-inverseTransformCubeRoot"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-inverseTransformCubeRoot}{}}}
\subsection{Method \code{inverseTransformCubeRoot()}}{
Performes an inverse cube root transformation for the given values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$inverseTransformCubeRoot(value = "numeric")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A numeric or a vector of numerics to be analyzed.
(numeric)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The transformed values.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-inverseTransformArcsine"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-inverseTransformArcsine}{}}}
\subsection{Method \code{inverseTransformArcsine()}}{
Performes an inverse arcsine transformation for the given values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$inverseTransformArcsine(
  value = "numeric",
  lambda = "numeric"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A numeric or a vector of numerics to be analyzed.
(numeric)}

\item{\code{lambda}}{Normalization factor.
(numeric)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The transformed values.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-inverseTransformInverse"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-inverseTransformInverse}{}}}
\subsection{Method \code{inverseTransformInverse()}}{
Performes an inverse inverse-transformation for the given values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$inverseTransformInverse(value = "numeric")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A numeric or a vector of numerics to be analyzed.
(numeric)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The transformed values.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-inverseTransformTukeyLadderOfPowers"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-inverseTransformTukeyLadderOfPowers}{}}}
\subsection{Method \code{inverseTransformTukeyLadderOfPowers()}}{
Performes an inverse tukeyLOP transformation for the given values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$inverseTransformTukeyLadderOfPowers(
  value = "numeric",
  lambda = "numeric"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A numeric or a vector of numerics to be analyzed.
(numeric)}

\item{\code{lambda}}{Lambda factor.
(numeric)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The transformed values.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-inverseTransformBoxCox"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-inverseTransformBoxCox}{}}}
\subsection{Method \code{inverseTransformBoxCox()}}{
Performes an inverse boxcox transformation for the given values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$inverseTransformBoxCox(value = "numeric", lambda = "numeric")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A numeric or a vector of numerics to be analyzed.
(numeric)}

\item{\code{lambda}}{Lambda factor.
(numeric)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The transformed values.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-fit"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-fit}{}}}
\subsection{Method \code{fit()}}{
Estimate all transformation parameters(lambda, addConst,...)
for each attribute of a given data frame.
The function calls the class' functions calculateAddConst and estimateLambda.
The results are stored in the respective attributes of the instance variable trafoParameter.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$fit(data = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A data frame.
(tibble:tibble)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-mutateData"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-mutateData}{}}}
\subsection{Method \code{mutateData()}}{
Mutates the values of each attribute of a given data frame.
Here, mutation is defined as the cesecutive sequence of the class'
functions mirrorData, tranlsateData and transfromData.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$mutateData(data = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A data frame.
(tibble:tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A mutated data frame.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-reverseMutateData"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-reverseMutateData}{}}}
\subsection{Method \code{reverseMutateData()}}{
Re-mutates the values of each attribute of a given data frame.
Here, re-mutation is defined as the cesecutive sequence of the class'
functions inverseTransformData, backTranslateData, mirrorData
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$reverseMutateData(data = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A data frame.
(tibble:tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A mutated data frame.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.transformator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.transformator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.transformator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
