% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/satorraBentler.R
\name{satorraBentlerScaledChiSquareDifferenceTestStatistic}
\alias{satorraBentlerScaledChiSquareDifferenceTestStatistic}
\title{Satorra-Bentler Scaled Chi-Square Difference Test Statistic.}
\usage{
satorraBentlerScaledChiSquareDifferenceTestStatistic(T0, c0, d0, T1, c1, d1)
}
\arguments{
\item{T0}{Value of the chi-square statistic for the nested model.}

\item{c0}{Value of the scaling correction factor for the nested model.}

\item{d0}{Number of model degrees of freedom for the nested model.}

\item{T1}{Value of the chi-square statistic for the comparison model.}

\item{c1}{Value of the scaling correction factor for the comparison model.}

\item{d1}{Number of model degrees of freedom for the comparison model.}
}
\value{
Satorra-Bentler Scaled Chi-Square Difference Test statistic.
}
\description{
Function that computes the Satorra-Bentler Scaled Chi-Square Difference Test
statistic.
}
\details{
Computes the Satorra-Bentler Scaled Chi-Square Difference Test statistic
between two structural equation models.
}
\examples{
# Fit structural equation model
HS.model <- '
 visual =~ x1 + x2 + x3
 textual =~ x4 + x5 + x6
 speed =~ x7 + x8 + x9
'

fit1 <- lavaan::cfa(HS.model, data = lavaan::HolzingerSwineford1939,
 estimator = "MLR")
fit0 <- lavaan::cfa(HS.model, data = lavaan::HolzingerSwineford1939,
 orthogonal = TRUE, estimator = "MLR")

# Chi-square difference test
# lavaan::anova(fit1, fit0)
satorraBentlerScaledChiSquareDifferenceTestStatistic(
 T0 = lavaan::fitMeasures(fit0)["chisq.scaled"],
 c0 = lavaan::fitMeasures(fit0)["chisq.scaling.factor"],
 d0 = lavaan::fitMeasures(fit0)["df.scaled"],
 T1 = lavaan::fitMeasures(fit1)["chisq.scaled"],
 c1 = lavaan::fitMeasures(fit1)["chisq.scaling.factor"],
 d1 = lavaan::fitMeasures(fit1)["df.scaled"])
}
\seealso{
Other structural equation modeling: 
\code{\link{equiv_chi}()},
\code{\link{make_esem_model}()},
\code{\link{puc}()},
\code{\link{semPlotInteraction}()}
}
\concept{structural equation modeling}
