% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accuracyAtCutoff.R
\name{accuracyAtCutoff}
\alias{accuracyAtCutoff}
\title{Accuracy at a Given Cutoff.}
\usage{
accuracyAtCutoff(
  predicted = NULL,
  actual = NULL,
  cutoff = NULL,
  TP = NULL,
  TN = NULL,
  FP = NULL,
  FN = NULL,
  UH = NULL,
  UM = NULL,
  UCR = NULL,
  UFA = NULL
)
}
\arguments{
\item{predicted}{vector of continuous predicted values.}

\item{actual}{vector of binary actual values (\code{1} = present and \code{0}
= absent).}

\item{cutoff}{numeric value at or above which the target condition is
considered present.}

\item{TP}{number of true positive cases.}

\item{TN}{number of true negative cases.}

\item{FP}{number of false positive cases.}

\item{FN}{number of false negative cases.}

\item{UH}{(optional) utility of hits (true positives), specified as a value
from 0-1, where 1 is the most highly valued and 0 is the least valued.}

\item{UM}{(optional) utility of misses (false negatives), specified as a
value from 0-1, where 1 is the most highly valued and 0 is the least valued.}

\item{UCR}{(optional) utility of correct rejections (true negatives),
specified as a value from 0-1, where 1 is the most highly valued and 0 is the
least valued.}

\item{UFA}{(optional) utility of false positives (false positives), specified
as a value from 0-1, where 1 is the most highly valued and 0 is the least
valued.}
}
\value{
\itemize{
  \item \code{cutoff} = the cutoff specified
  \item \code{TP} = true positives
  \item \code{TN} = true negatives
  \item \code{FP} = false positives
  \item \code{FN} = false negatives
  \item \code{SR} = selection ratio
  \item \code{BR} = base rate
  \item \code{percentAccuracy} = percent accuracy
  \item \code{percentAccuracyByChance} = percent accuracy by chance
  \item \code{percentAccuracyPredictingFromBaseRate} = percent accuracy from
  predicting from the base rate
  \item \code{RIOC} = relative improvement over chance
  \item \code{relativeImprovementOverPredictingFromBaseRate} = relative
  improvement over predicting from the base rate
  \item \code{SN} = sensitivty
  \item \code{SP} = specificity
  \item \code{TPrate} = true positive rate
  \item \code{TNrate} = true negative rate
  \item \code{FNrate} = false negative rate
  \item \code{FPrate} = false positive rate
  \item \code{HR} = hit rate
  \item \code{FAR} = false alarm rate
  \item \code{PPV} = positive predictive value
  \item \code{NPV} = negative predictive value
  \item \code{FDR} = false discovery rate
  \item \code{FOR} = false omission rate
  \item \code{youdenJ} = Youden's J statistic
  \item \code{balancedAccuracy} = balanced accuracy
  \item \code{f1Score} = F1-score
  \item \code{mcc} = Matthews correlation coefficient
  \item \code{diagnosticOddsRatio} = diagnostic odds ratio
  \item \code{positiveLikelihoodRatio} = positive likelihood ratio
  \item \code{negativeLikelhoodRatio} = negative likelihood ratio
  \item \code{dPrimeSDT} = d-Prime index from signal detection theory
  \item \code{betaSDT} = beta index from signal detection theory
  \item \code{cSDT} = c index from signal detection theory
  \item \code{aSDT} = a index from signal detection theory
  \item \code{bSDT} = b index from signal detection theory
  \item \code{informationGain} = information gain
  \item \code{overallUtility} = overall utility (if utilities were specified)
  \item \code{differenceBetweenPredictedAndObserved} = difference between
  predicted and observed values
}
}
\description{
Find the accuracy at a given cutoff. Actuals should be binary, where \code{1}
= present and \code{0} = absent.
}
\details{
Compute accuracy indices of predicted values in relation to actual values
at a given cutoff by specifying either a) the predicted values, actual
values, and cutoff value, or b) the number of true positives (TP), true
negatives (TN), false positives (FPs), and false negatives (FN). The target
condition is considered present at or above the cutoff value. Optionally, you
can also specify the utility of hits, misses, correct rejections, and false
alarms to calculate the overall utility of the cutoff. To compute accuracy at
each possible cutoff, see \link{accuracyAtEachCutoff}.
}
\examples{
# Prepare Data
data("USArrests")
USArrests$highMurderState <- NA
USArrests$highMurderState[which(USArrests$Murder >= 10)] <- 1
USArrests$highMurderState[which(USArrests$Murder < 10)] <- 0

# Calculate Accuracy
accuracyAtCutoff(predicted = USArrests$Assault,
  actual = USArrests$highMurderState, cutoff = 200)

accuracyAtCutoff(predicted = USArrests$Assault,
  actual = USArrests$highMurderState, cutoff = 200,
  UH = 1, UM = 0, UCR = .9, UFA = 0)

accuracyAtCutoff(TP = 30, TN = 20, FP = 15, FN = 35,
  UH = 1, UM = 0, UCR = .9, UFA = 0)
}
\seealso{
Other accuracy: 
\code{\link{accuracyAtEachCutoff}()},
\code{\link{accuracyOverall}()},
\code{\link{nomogrammer}()},
\code{\link{optimalCutoff}()},
\code{\link{posttestOdds}()}
}
\concept{accuracy}
