% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_features_OHE.R
\name{extract_features_OHE}
\alias{extract_features_OHE}
\title{Extract One-Hot Encoded (OHE) Features from Peptide Sequences}
\usage{
extract_features_OHE(df, sequence_col = "Sequence", docking_col = NULL)
}
\arguments{
\item{df}{A data frame or a vector of peptide sequences.}

\item{sequence_col}{A string representing the name of the column containing the peptide sequences.}

\item{docking_col}{A string representing the name of the column containing the docking information.}
}
\value{
A data frame containing one-hot encoded peptide sequences and, if provided, docking information.
}
\description{
This function takes a data frame or a vector of peptide sequences and generates
a one-hot encoded data frame representing each amino acid in the sequences.
It can also include additional data (such as docking information), if provided.
}
\examples{
# Load required library caret
library(caret)
# Generate a mock data frame of peptide sequences
df <- data.frame(Sequence = c("AVILG", "VILGA", "ILGAV", "LGAVI"), X = c(1,1,2,3))
# Apply the function to the mock data
extract_features_OHE(df)
}
