% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdgeUG2D.R
\name{inci.mat.undPEtri}
\alias{inci.mat.undPEtri}
\title{Incidence matrix for the underlying or reflexivity graph of
Proportional Edge Proximity Catch Digraphs (PE-PCDs) -
one triangle case}
\usage{
inci.mat.undPEtri(
  Xp,
  tri,
  r,
  M = c(1, 1, 1),
  ugraph = c("underlying", "reflexivity")
)
}
\arguments{
\item{Xp}{A set of 2D points
which constitute the vertices of the underlying
or reflexivity graph of the PE-PCD.}

\item{tri}{A \eqn{3 \times 2} matrix with each row
representing a vertex of the triangle.}

\item{r}{A positive real number
which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{M}{A 2D point in Cartesian coordinates
or a 3D point in barycentric coordinates
which serves as a center in the interior of the triangle \code{tri}
or the circumcenter of \code{tri}
which may be entered as "CC" as well;
default is \eqn{M=(1,1,1)}, i.e., the center of mass of \code{tri}.}

\item{ugraph}{The type of the graph based on PE-PCDs,
\code{"underlying"} is for the underlying graph, and \code{"reflexivity"} is for
the reflexivity graph (default is \code{"underlying"}).}
}
\value{
Incidence matrix for the underlying or reflexivity graph
of the PE-PCD with vertices
being 2D data set, \code{Xp}
in the triangle \code{tri} with vertex regions based on center \code{M}
}
\description{
Returns the incidence matrix
for the underlying or reflexivity graph of the PE-PCD
whose vertices are the given 2D numerical data set, \code{Xp},
in the triangle \code{tri}\eqn{=T(v=1,v=2,v=3)}.

PE proximity regions are constructed with respect to triangle \code{tri}
with expansion parameter \eqn{r \ge 1}
and vertex regions are based on the center \eqn{M=(m_1,m_2)}
in Cartesian coordinates
or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates
in the interior of the triangle \code{tri};
default is \eqn{M=(1,1,1)}, i.e., the center of mass of \code{tri}.
Loops are allowed, so the diagonal entries are all equal to 1.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:stamet2016;textual}{pcds.ugraph}).
}
\examples{
#\donttest{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
n<-10

set.seed(1)
Xp<-pcds::runif.tri(n,Tr)$g

M<-as.numeric(pcds::runif.tri(1,Tr)$g)
(IM<-inci.mat.undPEtri(Xp,Tr,r=1.25,M))
pcds::dom.num.greedy(IM)
pcds::Idom.num.up.bnd(IM,3)

(IM<-inci.mat.undPEtri(Xp,Tr,r=1.25,M,ugraph="r"))
pcds::dom.num.greedy(IM)
pcds::Idom.num.up.bnd(IM,3)
#}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{inci.mat.undPE}}, \code{\link{inci.mat.undAStri}},
\code{\link{inci.mat.undCStri}}, and \code{\link[pcds]{inci.matPEtri}}
}
\author{
Elvan Ceyhan
}
