% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSimUG2D.R
\name{inci.mat.undCSstd.tri}
\alias{inci.mat.undCSstd.tri}
\title{Incidence matrix for the underlying or reflexivity graphs of
Central Similarity Proximity Catch Digraphs (CS-PCDs) -
standard equilateral triangle case}
\usage{
inci.mat.undCSstd.tri(
  Xp,
  t,
  M = c(1, 1, 1),
  ugraph = c("underlying", "reflexivity")
)
}
\arguments{
\item{Xp}{A set of 2D points
which constitute the vertices of the underlying
or reflexivity graphs of the CS-PCD.}

\item{t}{A positive real number
which serves as the expansion parameter in CS proximity region.}

\item{M}{A 2D point in Cartesian coordinates
or a 3D point in barycentric coordinates
which serves as a center
in the interior of the standard equilateral triangle \eqn{T_e};
default is \eqn{M=(1,1,1)} i.e.
the center of mass of \eqn{T_e}.}

\item{ugraph}{The type of the graph based on CS-PCDs,
\code{"underlying"} is for the underlying graph,
and \code{"reflexivity"} is for
the reflexivity graph (default is \code{"underlying"}).}
}
\value{
Incidence matrix for the underlying or reflexivity graphs
of the CS-PCD with vertices
being 2D data set, \code{Xp}
in the standard equilateral triangle where CS proximity
regions are defined with \code{M}-edge regions.
}
\description{
Returns the incidence matrix
for the underlying or reflexivity graphs of the CS-PCD
whose vertices are the given 2D numerical data set, \code{Xp},
in the standard equilateral triangle
\eqn{T_e=T(v=1,v=2,v=3)=T((0,0),(1,0),(1/2,\sqrt{3}/2))}.

CS proximity region is constructed
with respect to the standard equilateral triangle \eqn{T_e} with
expansion parameter \eqn{t > 0} and edge regions are based on
the center \eqn{M=(m_1,m_2)} in Cartesian coordinates
or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates
in the interior of \eqn{T_e}; default is \eqn{M=(1,1,1)},
i.e., the center of mass of \eqn{T_e}.
Loops are allowed,
so the diagonal entries are all equal to 1.

See also
(\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:stamet2016;textual}{pcds.ugraph}).
}
\examples{
#\donttest{
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
Te<-rbind(A,B,C)
n<-10

set.seed(1)
Xp<-pcds::runif.std.tri(n)$gen.points

M<-as.numeric(pcds::runif.std.tri(1)$g)

inc.mat<-inci.mat.undCSstd.tri(Xp,t=1.5,M)
inc.mat
(sum(inc.mat)-n)/2
num.edgesCSstd.tri(Xp,t=1.5,M)$num.edges

pcds::dom.num.greedy(inc.mat)
pcds::Idom.num.up.bnd(inc.mat,2)
#}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{inci.mat.undCStri}}, \code{\link{inci.mat.undCS}},
and \code{\link[pcds]{inci.matCSstd.tri}}
}
\author{
Elvan Ceyhan
}
